/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ModifyRiskEventsStatusResponse extends AbstractModel {

    /**
    * Whether this operation is asynchronous. 0: operation completed; 1: asynchronous operation in progress and DescribeRiskBatchStatus needs to be called by front end to check if the operation is completed.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("IsSync")
    @Expose
    private Long IsSync;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Whether this operation is asynchronous. 0: operation completed; 1: asynchronous operation in progress and DescribeRiskBatchStatus needs to be called by front end to check if the operation is completed.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return IsSync Whether this operation is asynchronous. 0: operation completed; 1: asynchronous operation in progress and DescribeRiskBatchStatus needs to be called by front end to check if the operation is completed.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getIsSync() {
        return this.IsSync;
    }

    /**
     * Set Whether this operation is asynchronous. 0: operation completed; 1: asynchronous operation in progress and DescribeRiskBatchStatus needs to be called by front end to check if the operation is completed.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param IsSync Whether this operation is asynchronous. 0: operation completed; 1: asynchronous operation in progress and DescribeRiskBatchStatus needs to be called by front end to check if the operation is completed.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setIsSync(Long IsSync) {
        this.IsSync = IsSync;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public ModifyRiskEventsStatusResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ModifyRiskEventsStatusResponse(ModifyRiskEventsStatusResponse source) {
        if (source.IsSync != null) {
            this.IsSync = new Long(source.IsSync);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "IsSync", this.IsSync);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

