/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class RecoverMalwaresResponse extends AbstractModel {

    /**
    * An array of IDs for successfully recovered items; if none, an empty array is returned.
    */
    @SerializedName("SuccessIds")
    @Expose
    private Long [] SuccessIds;

    /**
    * An array of IDs for items that failed to be recovered; if none, an empty array is returned.
    */
    @SerializedName("FailedIds")
    @Expose
    private Long [] FailedIds;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get An array of IDs for successfully recovered items; if none, an empty array is returned. 
     * @return SuccessIds An array of IDs for successfully recovered items; if none, an empty array is returned.
     */
    public Long [] getSuccessIds() {
        return this.SuccessIds;
    }

    /**
     * Set An array of IDs for successfully recovered items; if none, an empty array is returned.
     * @param SuccessIds An array of IDs for successfully recovered items; if none, an empty array is returned.
     */
    public void setSuccessIds(Long [] SuccessIds) {
        this.SuccessIds = SuccessIds;
    }

    /**
     * Get An array of IDs for items that failed to be recovered; if none, an empty array is returned. 
     * @return FailedIds An array of IDs for items that failed to be recovered; if none, an empty array is returned.
     */
    public Long [] getFailedIds() {
        return this.FailedIds;
    }

    /**
     * Set An array of IDs for items that failed to be recovered; if none, an empty array is returned.
     * @param FailedIds An array of IDs for items that failed to be recovered; if none, an empty array is returned.
     */
    public void setFailedIds(Long [] FailedIds) {
        this.FailedIds = FailedIds;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public RecoverMalwaresResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public RecoverMalwaresResponse(RecoverMalwaresResponse source) {
        if (source.SuccessIds != null) {
            this.SuccessIds = new Long[source.SuccessIds.length];
            for (int i = 0; i < source.SuccessIds.length; i++) {
                this.SuccessIds[i] = new Long(source.SuccessIds[i]);
            }
        }
        if (source.FailedIds != null) {
            this.FailedIds = new Long[source.FailedIds.length];
            for (int i = 0; i < source.FailedIds.length; i++) {
                this.FailedIds[i] = new Long(source.FailedIds[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "SuccessIds.", this.SuccessIds);
        this.setParamArraySimple(map, prefix + "FailedIds.", this.FailedIds);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

