/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class SyncAssetScanResponse extends AbstractModel {

    /**
    * Enumeration values are (in uppercase): NOTASK (no synchronization task), SYNCING (synchronizing), and FINISHED (synchronization completed)
    */
    @SerializedName("State")
    @Expose
    private String State;

    /**
    * Latest synchronization start time
    */
    @SerializedName("LatestStartTime")
    @Expose
    private String LatestStartTime;

    /**
    * Last sync end time
    */
    @SerializedName("LatestEndTime")
    @Expose
    private String LatestEndTime;

    /**
    * Task ID
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("TaskId")
    @Expose
    private Long TaskId;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Enumeration values are (in uppercase): NOTASK (no synchronization task), SYNCING (synchronizing), and FINISHED (synchronization completed) 
     * @return State Enumeration values are (in uppercase): NOTASK (no synchronization task), SYNCING (synchronizing), and FINISHED (synchronization completed)
     */
    public String getState() {
        return this.State;
    }

    /**
     * Set Enumeration values are (in uppercase): NOTASK (no synchronization task), SYNCING (synchronizing), and FINISHED (synchronization completed)
     * @param State Enumeration values are (in uppercase): NOTASK (no synchronization task), SYNCING (synchronizing), and FINISHED (synchronization completed)
     */
    public void setState(String State) {
        this.State = State;
    }

    /**
     * Get Latest synchronization start time 
     * @return LatestStartTime Latest synchronization start time
     */
    public String getLatestStartTime() {
        return this.LatestStartTime;
    }

    /**
     * Set Latest synchronization start time
     * @param LatestStartTime Latest synchronization start time
     */
    public void setLatestStartTime(String LatestStartTime) {
        this.LatestStartTime = LatestStartTime;
    }

    /**
     * Get Last sync end time 
     * @return LatestEndTime Last sync end time
     */
    public String getLatestEndTime() {
        return this.LatestEndTime;
    }

    /**
     * Set Last sync end time
     * @param LatestEndTime Last sync end time
     */
    public void setLatestEndTime(String LatestEndTime) {
        this.LatestEndTime = LatestEndTime;
    }

    /**
     * Get Task ID
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return TaskId Task ID
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getTaskId() {
        return this.TaskId;
    }

    /**
     * Set Task ID
Note: This field may return null, indicating that no valid values can be obtained.
     * @param TaskId Task ID
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setTaskId(Long TaskId) {
        this.TaskId = TaskId;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public SyncAssetScanResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public SyncAssetScanResponse(SyncAssetScanResponse source) {
        if (source.State != null) {
            this.State = new String(source.State);
        }
        if (source.LatestStartTime != null) {
            this.LatestStartTime = new String(source.LatestStartTime);
        }
        if (source.LatestEndTime != null) {
            this.LatestEndTime = new String(source.LatestEndTime);
        }
        if (source.TaskId != null) {
            this.TaskId = new Long(source.TaskId);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "State", this.State);
        this.setParamSimple(map, prefix + "LatestStartTime", this.LatestStartTime);
        this.setParamSimple(map, prefix + "LatestEndTime", this.LatestEndTime);
        this.setParamSimple(map, prefix + "TaskId", this.TaskId);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

