/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cynosdb.v20190107.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeBackupDownloadRestrictionResponse extends AbstractModel {

    /**
    * Cluster backup download limit.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("BackupLimitClusterRestrictions")
    @Expose
    private BackupLimitClusterRestriction [] BackupLimitClusterRestrictions;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Cluster backup download limit.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return BackupLimitClusterRestrictions Cluster backup download limit.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public BackupLimitClusterRestriction [] getBackupLimitClusterRestrictions() {
        return this.BackupLimitClusterRestrictions;
    }

    /**
     * Set Cluster backup download limit.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param BackupLimitClusterRestrictions Cluster backup download limit.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setBackupLimitClusterRestrictions(BackupLimitClusterRestriction [] BackupLimitClusterRestrictions) {
        this.BackupLimitClusterRestrictions = BackupLimitClusterRestrictions;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeBackupDownloadRestrictionResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeBackupDownloadRestrictionResponse(DescribeBackupDownloadRestrictionResponse source) {
        if (source.BackupLimitClusterRestrictions != null) {
            this.BackupLimitClusterRestrictions = new BackupLimitClusterRestriction[source.BackupLimitClusterRestrictions.length];
            for (int i = 0; i < source.BackupLimitClusterRestrictions.length; i++) {
                this.BackupLimitClusterRestrictions[i] = new BackupLimitClusterRestriction(source.BackupLimitClusterRestrictions[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "BackupLimitClusterRestrictions.", this.BackupLimitClusterRestrictions);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

