/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cynosdb.v20190107.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeServerlessStrategyResponse extends AbstractModel {

    /**
    * Specifies how long (in seconds) the auto-pause is triggered when the cpu load is 0.
    */
    @SerializedName("AutoPauseDelay")
    @Expose
    private Long AutoPauseDelay;

    /**
    * Specifies how long (in seconds) the auto-scaling is triggered when the cpu load exceeds the number of cores in the current specifications.
    */
    @SerializedName("AutoScaleUpDelay")
    @Expose
    private Long AutoScaleUpDelay;

    /**
    * Specifies how long (in seconds) the system will wait for the cpu load to be lower than the number of cores in the lower specification before triggering automatic scaling down.
    */
    @SerializedName("AutoScaleDownDelay")
    @Expose
    private Long AutoScaleDownDelay;

    /**
    * Whether to automatically pause. valid values:.
yes
no
    */
    @SerializedName("AutoPause")
    @Expose
    private String AutoPause;

    /**
    * Specifies whether the cluster allows upward scaling. valid values: <li>yes</li><li>no</li>.
    */
    @SerializedName("AutoScaleUp")
    @Expose
    private String AutoScaleUp;

    /**
    * Whether the cluster is allowed to scale down. valid values: <li>yes</li><li>no</li>.
    */
    @SerializedName("AutoScaleDown")
    @Expose
    private String AutoScaleDown;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Specifies how long (in seconds) the auto-pause is triggered when the cpu load is 0. 
     * @return AutoPauseDelay Specifies how long (in seconds) the auto-pause is triggered when the cpu load is 0.
     */
    public Long getAutoPauseDelay() {
        return this.AutoPauseDelay;
    }

    /**
     * Set Specifies how long (in seconds) the auto-pause is triggered when the cpu load is 0.
     * @param AutoPauseDelay Specifies how long (in seconds) the auto-pause is triggered when the cpu load is 0.
     */
    public void setAutoPauseDelay(Long AutoPauseDelay) {
        this.AutoPauseDelay = AutoPauseDelay;
    }

    /**
     * Get Specifies how long (in seconds) the auto-scaling is triggered when the cpu load exceeds the number of cores in the current specifications. 
     * @return AutoScaleUpDelay Specifies how long (in seconds) the auto-scaling is triggered when the cpu load exceeds the number of cores in the current specifications.
     */
    public Long getAutoScaleUpDelay() {
        return this.AutoScaleUpDelay;
    }

    /**
     * Set Specifies how long (in seconds) the auto-scaling is triggered when the cpu load exceeds the number of cores in the current specifications.
     * @param AutoScaleUpDelay Specifies how long (in seconds) the auto-scaling is triggered when the cpu load exceeds the number of cores in the current specifications.
     */
    public void setAutoScaleUpDelay(Long AutoScaleUpDelay) {
        this.AutoScaleUpDelay = AutoScaleUpDelay;
    }

    /**
     * Get Specifies how long (in seconds) the system will wait for the cpu load to be lower than the number of cores in the lower specification before triggering automatic scaling down. 
     * @return AutoScaleDownDelay Specifies how long (in seconds) the system will wait for the cpu load to be lower than the number of cores in the lower specification before triggering automatic scaling down.
     */
    public Long getAutoScaleDownDelay() {
        return this.AutoScaleDownDelay;
    }

    /**
     * Set Specifies how long (in seconds) the system will wait for the cpu load to be lower than the number of cores in the lower specification before triggering automatic scaling down.
     * @param AutoScaleDownDelay Specifies how long (in seconds) the system will wait for the cpu load to be lower than the number of cores in the lower specification before triggering automatic scaling down.
     */
    public void setAutoScaleDownDelay(Long AutoScaleDownDelay) {
        this.AutoScaleDownDelay = AutoScaleDownDelay;
    }

    /**
     * Get Whether to automatically pause. valid values:.
yes
no 
     * @return AutoPause Whether to automatically pause. valid values:.
yes
no
     */
    public String getAutoPause() {
        return this.AutoPause;
    }

    /**
     * Set Whether to automatically pause. valid values:.
yes
no
     * @param AutoPause Whether to automatically pause. valid values:.
yes
no
     */
    public void setAutoPause(String AutoPause) {
        this.AutoPause = AutoPause;
    }

    /**
     * Get Specifies whether the cluster allows upward scaling. valid values: <li>yes</li><li>no</li>. 
     * @return AutoScaleUp Specifies whether the cluster allows upward scaling. valid values: <li>yes</li><li>no</li>.
     */
    public String getAutoScaleUp() {
        return this.AutoScaleUp;
    }

    /**
     * Set Specifies whether the cluster allows upward scaling. valid values: <li>yes</li><li>no</li>.
     * @param AutoScaleUp Specifies whether the cluster allows upward scaling. valid values: <li>yes</li><li>no</li>.
     */
    public void setAutoScaleUp(String AutoScaleUp) {
        this.AutoScaleUp = AutoScaleUp;
    }

    /**
     * Get Whether the cluster is allowed to scale down. valid values: <li>yes</li><li>no</li>. 
     * @return AutoScaleDown Whether the cluster is allowed to scale down. valid values: <li>yes</li><li>no</li>.
     */
    public String getAutoScaleDown() {
        return this.AutoScaleDown;
    }

    /**
     * Set Whether the cluster is allowed to scale down. valid values: <li>yes</li><li>no</li>.
     * @param AutoScaleDown Whether the cluster is allowed to scale down. valid values: <li>yes</li><li>no</li>.
     */
    public void setAutoScaleDown(String AutoScaleDown) {
        this.AutoScaleDown = AutoScaleDown;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeServerlessStrategyResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeServerlessStrategyResponse(DescribeServerlessStrategyResponse source) {
        if (source.AutoPauseDelay != null) {
            this.AutoPauseDelay = new Long(source.AutoPauseDelay);
        }
        if (source.AutoScaleUpDelay != null) {
            this.AutoScaleUpDelay = new Long(source.AutoScaleUpDelay);
        }
        if (source.AutoScaleDownDelay != null) {
            this.AutoScaleDownDelay = new Long(source.AutoScaleDownDelay);
        }
        if (source.AutoPause != null) {
            this.AutoPause = new String(source.AutoPause);
        }
        if (source.AutoScaleUp != null) {
            this.AutoScaleUp = new String(source.AutoScaleUp);
        }
        if (source.AutoScaleDown != null) {
            this.AutoScaleDown = new String(source.AutoScaleDown);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "AutoPauseDelay", this.AutoPauseDelay);
        this.setParamSimple(map, prefix + "AutoScaleUpDelay", this.AutoScaleUpDelay);
        this.setParamSimple(map, prefix + "AutoScaleDownDelay", this.AutoScaleDownDelay);
        this.setParamSimple(map, prefix + "AutoPause", this.AutoPause);
        this.setParamSimple(map, prefix + "AutoScaleUp", this.AutoScaleUp);
        this.setParamSimple(map, prefix + "AutoScaleDown", this.AutoScaleDown);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

