/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cynosdb.v20190107.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ErrorLogItemExport extends AbstractModel {

    /**
    * Time
    */
    @SerializedName("Timestamp")
    @Expose
    private String Timestamp;

    /**
    * Specifies the log level. valid values are note, warning, and error.
    */
    @SerializedName("Level")
    @Expose
    private String Level;

    /**
    * Log content.
    */
    @SerializedName("Content")
    @Expose
    private String Content;

    /**
     * Get Time 
     * @return Timestamp Time
     */
    public String getTimestamp() {
        return this.Timestamp;
    }

    /**
     * Set Time
     * @param Timestamp Time
     */
    public void setTimestamp(String Timestamp) {
        this.Timestamp = Timestamp;
    }

    /**
     * Get Specifies the log level. valid values are note, warning, and error. 
     * @return Level Specifies the log level. valid values are note, warning, and error.
     */
    public String getLevel() {
        return this.Level;
    }

    /**
     * Set Specifies the log level. valid values are note, warning, and error.
     * @param Level Specifies the log level. valid values are note, warning, and error.
     */
    public void setLevel(String Level) {
        this.Level = Level;
    }

    /**
     * Get Log content. 
     * @return Content Log content.
     */
    public String getContent() {
        return this.Content;
    }

    /**
     * Set Log content.
     * @param Content Log content.
     */
    public void setContent(String Content) {
        this.Content = Content;
    }

    public ErrorLogItemExport() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ErrorLogItemExport(ErrorLogItemExport source) {
        if (source.Timestamp != null) {
            this.Timestamp = new String(source.Timestamp);
        }
        if (source.Level != null) {
            this.Level = new String(source.Level);
        }
        if (source.Content != null) {
            this.Content = new String(source.Content);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Timestamp", this.Timestamp);
        this.setParamSimple(map, prefix + "Level", this.Level);
        this.setParamSimple(map, prefix + "Content", this.Content);

    }
}

