/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cynosdb.v20190107.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ExportInstanceErrorLogsResponse extends AbstractModel {

    /**
    * Exported error log content.
    */
    @SerializedName("ErrorLogItems")
    @Expose
    private ErrorLogItemExport [] ErrorLogItems;

    /**
    * Error log string.
    */
    @SerializedName("FileContent")
    @Expose
    private String FileContent;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Exported error log content. 
     * @return ErrorLogItems Exported error log content.
     */
    public ErrorLogItemExport [] getErrorLogItems() {
        return this.ErrorLogItems;
    }

    /**
     * Set Exported error log content.
     * @param ErrorLogItems Exported error log content.
     */
    public void setErrorLogItems(ErrorLogItemExport [] ErrorLogItems) {
        this.ErrorLogItems = ErrorLogItems;
    }

    /**
     * Get Error log string. 
     * @return FileContent Error log string.
     */
    public String getFileContent() {
        return this.FileContent;
    }

    /**
     * Set Error log string.
     * @param FileContent Error log string.
     */
    public void setFileContent(String FileContent) {
        this.FileContent = FileContent;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public ExportInstanceErrorLogsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ExportInstanceErrorLogsResponse(ExportInstanceErrorLogsResponse source) {
        if (source.ErrorLogItems != null) {
            this.ErrorLogItems = new ErrorLogItemExport[source.ErrorLogItems.length];
            for (int i = 0; i < source.ErrorLogItems.length; i++) {
                this.ErrorLogItems[i] = new ErrorLogItemExport(source.ErrorLogItems[i]);
            }
        }
        if (source.FileContent != null) {
            this.FileContent = new String(source.FileContent);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "ErrorLogItems.", this.ErrorLogItems);
        this.setParamSimple(map, prefix + "FileContent", this.FileContent);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

