package com.tencentcloudapi.dayu.v20180709;
public enum DayuErrorCode {
     /* `DryRun` Operation. It means that the request would have succeeded, but the `DryRun` parameter was used. */
     DRYRUNOPERATION("DryRunOperation"),
     
     /* Operation failed. */
     FAILEDOPERATION("FailedOperation"),
     
     /* An internal error occurred. */
     INTERNALERROR("InternalError"),
     
     /* A parameter error occurred. */
     INVALIDPARAMETER("InvalidParameter"),
     
     /* Incorrect parameter value. */
     INVALIDPARAMETERVALUE("InvalidParameterValue"),
     
     /* The quota limit is exceeded. */
     LIMITEXCEEDED("LimitExceeded"),
     
     /* Missing parameter. */
     MISSINGPARAMETER("MissingParameter"),
     
     /* The resource is occupied. */
     RESOURCEINUSE("ResourceInUse"),
     
     /* The resource does not exist. */
     RESOURCENOTFOUND("ResourceNotFound"),
     
     /* The resource is unavailable */
     RESOURCEUNAVAILABLE("ResourceUnavailable"),
     
     /* Unknown parameter error. */
     UNKNOWNPARAMETER("UnknownParameter"),
     
     /* Unsupported operation. */
     UNSUPPORTEDOPERATION("UnsupportedOperation");
     
    private String value;
    private DayuErrorCode (String value){
        this.value = value;
    }
    /**
     * @return errorcode value
     */
    public String getValue() {
        return value;
    }
}

