/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.dayu.v20180709.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeBizHttpStatusResponse extends AbstractModel {

    /**
    * Statistics on the HTTP status codes of business traffic
    */
    @SerializedName("HttpStatusMap")
    @Expose
    private HttpStatusMap HttpStatusMap;

    /**
    * The unique request ID, which is returned for each request. RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Statistics on the HTTP status codes of business traffic 
     * @return HttpStatusMap Statistics on the HTTP status codes of business traffic
     */
    public HttpStatusMap getHttpStatusMap() {
        return this.HttpStatusMap;
    }

    /**
     * Set Statistics on the HTTP status codes of business traffic
     * @param HttpStatusMap Statistics on the HTTP status codes of business traffic
     */
    public void setHttpStatusMap(HttpStatusMap HttpStatusMap) {
        this.HttpStatusMap = HttpStatusMap;
    }

    /**
     * Get The unique request ID, which is returned for each request. RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     * @param RequestId The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeBizHttpStatusResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeBizHttpStatusResponse(DescribeBizHttpStatusResponse source) {
        if (source.HttpStatusMap != null) {
            this.HttpStatusMap = new HttpStatusMap(source.HttpStatusMap);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "HttpStatusMap.", this.HttpStatusMap);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

