/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.dcdb.v20180411.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeDCDBShardsResponse extends AbstractModel {

    /**
    * Number of eligible shards
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Shard information list
    */
    @SerializedName("Shards")
    @Expose
    private DCDBShardInfo [] Shards;

    /**
    * Disaster recovery flag. Valid values: 0 (none), 1 (source instance), 2 (disaster recovery instance)
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("DcnFlag")
    @Expose
    private Long DcnFlag;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Number of eligible shards 
     * @return TotalCount Number of eligible shards
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Number of eligible shards
     * @param TotalCount Number of eligible shards
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Shard information list 
     * @return Shards Shard information list
     */
    public DCDBShardInfo [] getShards() {
        return this.Shards;
    }

    /**
     * Set Shard information list
     * @param Shards Shard information list
     */
    public void setShards(DCDBShardInfo [] Shards) {
        this.Shards = Shards;
    }

    /**
     * Get Disaster recovery flag. Valid values: 0 (none), 1 (source instance), 2 (disaster recovery instance)
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return DcnFlag Disaster recovery flag. Valid values: 0 (none), 1 (source instance), 2 (disaster recovery instance)
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getDcnFlag() {
        return this.DcnFlag;
    }

    /**
     * Set Disaster recovery flag. Valid values: 0 (none), 1 (source instance), 2 (disaster recovery instance)
Note: This field may return null, indicating that no valid values can be obtained.
     * @param DcnFlag Disaster recovery flag. Valid values: 0 (none), 1 (source instance), 2 (disaster recovery instance)
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setDcnFlag(Long DcnFlag) {
        this.DcnFlag = DcnFlag;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeDCDBShardsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeDCDBShardsResponse(DescribeDCDBShardsResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.Shards != null) {
            this.Shards = new DCDBShardInfo[source.Shards.length];
            for (int i = 0; i < source.Shards.length; i++) {
                this.Shards[i] = new DCDBShardInfo(source.Shards[i]);
            }
        }
        if (source.DcnFlag != null) {
            this.DcnFlag = new Long(source.DcnFlag);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArrayObj(map, prefix + "Shards.", this.Shards);
        this.setParamSimple(map, prefix + "DcnFlag", this.DcnFlag);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

