/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.dcdb.v20180411.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeDatabaseObjectsResponse extends AbstractModel {

    /**
    * Passed through from input parameters.
    */
    @SerializedName("InstanceId")
    @Expose
    private String InstanceId;

    /**
    * Database name.
    */
    @SerializedName("DbName")
    @Expose
    private String DbName;

    /**
    * Table list.
    */
    @SerializedName("Tables")
    @Expose
    private DatabaseTable [] Tables;

    /**
    * View list.
    */
    @SerializedName("Views")
    @Expose
    private DatabaseView [] Views;

    /**
    * Stored procedure list.
    */
    @SerializedName("Procs")
    @Expose
    private DatabaseProcedure [] Procs;

    /**
    * Function list.
    */
    @SerializedName("Funcs")
    @Expose
    private DatabaseFunction [] Funcs;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Passed through from input parameters. 
     * @return InstanceId Passed through from input parameters.
     */
    public String getInstanceId() {
        return this.InstanceId;
    }

    /**
     * Set Passed through from input parameters.
     * @param InstanceId Passed through from input parameters.
     */
    public void setInstanceId(String InstanceId) {
        this.InstanceId = InstanceId;
    }

    /**
     * Get Database name. 
     * @return DbName Database name.
     */
    public String getDbName() {
        return this.DbName;
    }

    /**
     * Set Database name.
     * @param DbName Database name.
     */
    public void setDbName(String DbName) {
        this.DbName = DbName;
    }

    /**
     * Get Table list. 
     * @return Tables Table list.
     */
    public DatabaseTable [] getTables() {
        return this.Tables;
    }

    /**
     * Set Table list.
     * @param Tables Table list.
     */
    public void setTables(DatabaseTable [] Tables) {
        this.Tables = Tables;
    }

    /**
     * Get View list. 
     * @return Views View list.
     */
    public DatabaseView [] getViews() {
        return this.Views;
    }

    /**
     * Set View list.
     * @param Views View list.
     */
    public void setViews(DatabaseView [] Views) {
        this.Views = Views;
    }

    /**
     * Get Stored procedure list. 
     * @return Procs Stored procedure list.
     */
    public DatabaseProcedure [] getProcs() {
        return this.Procs;
    }

    /**
     * Set Stored procedure list.
     * @param Procs Stored procedure list.
     */
    public void setProcs(DatabaseProcedure [] Procs) {
        this.Procs = Procs;
    }

    /**
     * Get Function list. 
     * @return Funcs Function list.
     */
    public DatabaseFunction [] getFuncs() {
        return this.Funcs;
    }

    /**
     * Set Function list.
     * @param Funcs Function list.
     */
    public void setFuncs(DatabaseFunction [] Funcs) {
        this.Funcs = Funcs;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeDatabaseObjectsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeDatabaseObjectsResponse(DescribeDatabaseObjectsResponse source) {
        if (source.InstanceId != null) {
            this.InstanceId = new String(source.InstanceId);
        }
        if (source.DbName != null) {
            this.DbName = new String(source.DbName);
        }
        if (source.Tables != null) {
            this.Tables = new DatabaseTable[source.Tables.length];
            for (int i = 0; i < source.Tables.length; i++) {
                this.Tables[i] = new DatabaseTable(source.Tables[i]);
            }
        }
        if (source.Views != null) {
            this.Views = new DatabaseView[source.Views.length];
            for (int i = 0; i < source.Views.length; i++) {
                this.Views[i] = new DatabaseView(source.Views[i]);
            }
        }
        if (source.Procs != null) {
            this.Procs = new DatabaseProcedure[source.Procs.length];
            for (int i = 0; i < source.Procs.length; i++) {
                this.Procs[i] = new DatabaseProcedure(source.Procs[i]);
            }
        }
        if (source.Funcs != null) {
            this.Funcs = new DatabaseFunction[source.Funcs.length];
            for (int i = 0; i < source.Funcs.length; i++) {
                this.Funcs[i] = new DatabaseFunction(source.Funcs[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "InstanceId", this.InstanceId);
        this.setParamSimple(map, prefix + "DbName", this.DbName);
        this.setParamArrayObj(map, prefix + "Tables.", this.Tables);
        this.setParamArrayObj(map, prefix + "Views.", this.Views);
        this.setParamArrayObj(map, prefix + "Procs.", this.Procs);
        this.setParamArrayObj(map, prefix + "Funcs.", this.Funcs);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

