/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.dlc.v20210125.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DeleteDataMaskStrategyRequest extends AbstractModel {

    /**
    * DMask policy Id. specifies the Id of the data masking policy.
    */
    @SerializedName("StrategyId")
    @Expose
    private String StrategyId;

    /**
     * Get DMask policy Id. specifies the Id of the data masking policy. 
     * @return StrategyId DMask policy Id. specifies the Id of the data masking policy.
     */
    public String getStrategyId() {
        return this.StrategyId;
    }

    /**
     * Set DMask policy Id. specifies the Id of the data masking policy.
     * @param StrategyId DMask policy Id. specifies the Id of the data masking policy.
     */
    public void setStrategyId(String StrategyId) {
        this.StrategyId = StrategyId;
    }

    public DeleteDataMaskStrategyRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DeleteDataMaskStrategyRequest(DeleteDataMaskStrategyRequest source) {
        if (source.StrategyId != null) {
            this.StrategyId = new String(source.StrategyId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "StrategyId", this.StrategyId);

    }
}

