/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.dlc.v20210125.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAdvancedStoreLocationResponse extends AbstractModel {

    /**
    * Whether to enable advanced settings. 0 means no while 1 means yes.
    */
    @SerializedName("Enable")
    @Expose
    private Long Enable;

    /**
    * COS path of saving querying results
    */
    @SerializedName("StoreLocation")
    @Expose
    private String StoreLocation;

    /**
    * Whether there is permission for managed storage
    */
    @SerializedName("HasLakeFs")
    @Expose
    private Boolean HasLakeFs;

    /**
    * Managed storage status. The value is meaningful only when HasLakeFs is equal to true.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("LakeFsStatus")
    @Expose
    private String LakeFsStatus;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Whether to enable advanced settings. 0 means no while 1 means yes. 
     * @return Enable Whether to enable advanced settings. 0 means no while 1 means yes.
     */
    public Long getEnable() {
        return this.Enable;
    }

    /**
     * Set Whether to enable advanced settings. 0 means no while 1 means yes.
     * @param Enable Whether to enable advanced settings. 0 means no while 1 means yes.
     */
    public void setEnable(Long Enable) {
        this.Enable = Enable;
    }

    /**
     * Get COS path of saving querying results 
     * @return StoreLocation COS path of saving querying results
     */
    public String getStoreLocation() {
        return this.StoreLocation;
    }

    /**
     * Set COS path of saving querying results
     * @param StoreLocation COS path of saving querying results
     */
    public void setStoreLocation(String StoreLocation) {
        this.StoreLocation = StoreLocation;
    }

    /**
     * Get Whether there is permission for managed storage 
     * @return HasLakeFs Whether there is permission for managed storage
     */
    public Boolean getHasLakeFs() {
        return this.HasLakeFs;
    }

    /**
     * Set Whether there is permission for managed storage
     * @param HasLakeFs Whether there is permission for managed storage
     */
    public void setHasLakeFs(Boolean HasLakeFs) {
        this.HasLakeFs = HasLakeFs;
    }

    /**
     * Get Managed storage status. The value is meaningful only when HasLakeFs is equal to true.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return LakeFsStatus Managed storage status. The value is meaningful only when HasLakeFs is equal to true.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getLakeFsStatus() {
        return this.LakeFsStatus;
    }

    /**
     * Set Managed storage status. The value is meaningful only when HasLakeFs is equal to true.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param LakeFsStatus Managed storage status. The value is meaningful only when HasLakeFs is equal to true.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setLakeFsStatus(String LakeFsStatus) {
        this.LakeFsStatus = LakeFsStatus;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAdvancedStoreLocationResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAdvancedStoreLocationResponse(DescribeAdvancedStoreLocationResponse source) {
        if (source.Enable != null) {
            this.Enable = new Long(source.Enable);
        }
        if (source.StoreLocation != null) {
            this.StoreLocation = new String(source.StoreLocation);
        }
        if (source.HasLakeFs != null) {
            this.HasLakeFs = new Boolean(source.HasLakeFs);
        }
        if (source.LakeFsStatus != null) {
            this.LakeFsStatus = new String(source.LakeFsStatus);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Enable", this.Enable);
        this.setParamSimple(map, prefix + "StoreLocation", this.StoreLocation);
        this.setParamSimple(map, prefix + "HasLakeFs", this.HasLakeFs);
        this.setParamSimple(map, prefix + "LakeFsStatus", this.LakeFsStatus);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

