/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.dlc.v20210125.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeJobResponse extends AbstractModel {

    /**
    * Job name
    */
    @SerializedName("JobName")
    @Expose
    private String JobName;

    /**
    * Task statistics information.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("StatisticInfo")
    @Expose
    private StatisticInfo StatisticInfo;

    /**
    * Job configuration
    */
    @SerializedName("JobConfiguration")
    @Expose
    private String JobConfiguration;

    /**
    * Job status:
    */
    @SerializedName("JobStatus")
    @Expose
    private Long JobStatus;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Job name 
     * @return JobName Job name
     */
    public String getJobName() {
        return this.JobName;
    }

    /**
     * Set Job name
     * @param JobName Job name
     */
    public void setJobName(String JobName) {
        this.JobName = JobName;
    }

    /**
     * Get Task statistics information.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return StatisticInfo Task statistics information.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public StatisticInfo getStatisticInfo() {
        return this.StatisticInfo;
    }

    /**
     * Set Task statistics information.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param StatisticInfo Task statistics information.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setStatisticInfo(StatisticInfo StatisticInfo) {
        this.StatisticInfo = StatisticInfo;
    }

    /**
     * Get Job configuration 
     * @return JobConfiguration Job configuration
     */
    public String getJobConfiguration() {
        return this.JobConfiguration;
    }

    /**
     * Set Job configuration
     * @param JobConfiguration Job configuration
     */
    public void setJobConfiguration(String JobConfiguration) {
        this.JobConfiguration = JobConfiguration;
    }

    /**
     * Get Job status: 
     * @return JobStatus Job status:
     */
    public Long getJobStatus() {
        return this.JobStatus;
    }

    /**
     * Set Job status:
     * @param JobStatus Job status:
     */
    public void setJobStatus(Long JobStatus) {
        this.JobStatus = JobStatus;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeJobResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeJobResponse(DescribeJobResponse source) {
        if (source.JobName != null) {
            this.JobName = new String(source.JobName);
        }
        if (source.StatisticInfo != null) {
            this.StatisticInfo = new StatisticInfo(source.StatisticInfo);
        }
        if (source.JobConfiguration != null) {
            this.JobConfiguration = new String(source.JobConfiguration);
        }
        if (source.JobStatus != null) {
            this.JobStatus = new Long(source.JobStatus);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "JobName", this.JobName);
        this.setParamObj(map, prefix + "StatisticInfo.", this.StatisticInfo);
        this.setParamSimple(map, prefix + "JobConfiguration", this.JobConfiguration);
        this.setParamSimple(map, prefix + "JobStatus", this.JobStatus);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

