/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.dlc.v20210125.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class WorkGroupIdSetOfUserId extends AbstractModel {

    /**
    * User ID, which matches Uin on the CAM side.
    */
    @SerializedName("UserId")
    @Expose
    private String UserId;

    /**
    * Collections of IDs of working groups
    */
    @SerializedName("WorkGroupIds")
    @Expose
    private Long [] WorkGroupIds;

    /**
     * Get User ID, which matches Uin on the CAM side. 
     * @return UserId User ID, which matches Uin on the CAM side.
     */
    public String getUserId() {
        return this.UserId;
    }

    /**
     * Set User ID, which matches Uin on the CAM side.
     * @param UserId User ID, which matches Uin on the CAM side.
     */
    public void setUserId(String UserId) {
        this.UserId = UserId;
    }

    /**
     * Get Collections of IDs of working groups 
     * @return WorkGroupIds Collections of IDs of working groups
     */
    public Long [] getWorkGroupIds() {
        return this.WorkGroupIds;
    }

    /**
     * Set Collections of IDs of working groups
     * @param WorkGroupIds Collections of IDs of working groups
     */
    public void setWorkGroupIds(Long [] WorkGroupIds) {
        this.WorkGroupIds = WorkGroupIds;
    }

    public WorkGroupIdSetOfUserId() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public WorkGroupIdSetOfUserId(WorkGroupIdSetOfUserId source) {
        if (source.UserId != null) {
            this.UserId = new String(source.UserId);
        }
        if (source.WorkGroupIds != null) {
            this.WorkGroupIds = new Long[source.WorkGroupIds.length];
            for (int i = 0; i < source.WorkGroupIds.length; i++) {
                this.WorkGroupIds[i] = new Long(source.WorkGroupIds[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "UserId", this.UserId);
        this.setParamArraySimple(map, prefix + "WorkGroupIds.", this.WorkGroupIds);

    }
}

