/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.domain.v20180808.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeIntlBatchDetailStatusRequest extends AbstractModel {

    /**
    * The IDs of the logs to be queried.
    */
    @SerializedName("LogIds")
    @Expose
    private Long [] LogIds;

    /**
     * Get The IDs of the logs to be queried. 
     * @return LogIds The IDs of the logs to be queried.
     */
    public Long [] getLogIds() {
        return this.LogIds;
    }

    /**
     * Set The IDs of the logs to be queried.
     * @param LogIds The IDs of the logs to be queried.
     */
    public void setLogIds(Long [] LogIds) {
        this.LogIds = LogIds;
    }

    public DescribeIntlBatchDetailStatusRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeIntlBatchDetailStatusRequest(DescribeIntlBatchDetailStatusRequest source) {
        if (source.LogIds != null) {
            this.LogIds = new Long[source.LogIds.length];
            for (int i = 0; i < source.LogIds.length; i++) {
                this.LogIds[i] = new Long(source.LogIds[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "LogIds.", this.LogIds);

    }
}

