/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ecm.v20190719.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class RuleHealth extends AbstractModel {

    /**
    * Health check status of the real server bound to the rule
Note: this field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Targets")
    @Expose
    private TargetHealth [] Targets;

    /**
     * Get Health check status of the real server bound to the rule
Note: this field may return null, indicating that no valid values can be obtained. 
     * @return Targets Health check status of the real server bound to the rule
Note: this field may return null, indicating that no valid values can be obtained.
     */
    public TargetHealth [] getTargets() {
        return this.Targets;
    }

    /**
     * Set Health check status of the real server bound to the rule
Note: this field may return null, indicating that no valid values can be obtained.
     * @param Targets Health check status of the real server bound to the rule
Note: this field may return null, indicating that no valid values can be obtained.
     */
    public void setTargets(TargetHealth [] Targets) {
        this.Targets = Targets;
    }

    public RuleHealth() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public RuleHealth(RuleHealth source) {
        if (source.Targets != null) {
            this.Targets = new TargetHealth[source.Targets.length];
            for (int i = 0; i < source.Targets.length; i++) {
                this.Targets[i] = new TargetHealth(source.Targets[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Targets.", this.Targets);

    }
}

