/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.eiam.v20210420.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAccountGroupResponse extends AbstractModel {

    /**
    * Total number of records returned for the query.
Note: this field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Application ID.
Note: this field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ApplicationId")
    @Expose
    private String ApplicationId;

    /**
    * Returned list of eligible data.
Note: this field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("AccountGroupList")
    @Expose
    private AccountGroupInfo [] AccountGroupList;

    /**
    * The unique request ID, which is returned for each request. RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of records returned for the query.
Note: this field may return null, indicating that no valid values can be obtained. 
     * @return TotalCount Total number of records returned for the query.
Note: this field may return null, indicating that no valid values can be obtained.
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number of records returned for the query.
Note: this field may return null, indicating that no valid values can be obtained.
     * @param TotalCount Total number of records returned for the query.
Note: this field may return null, indicating that no valid values can be obtained.
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Application ID.
Note: this field may return null, indicating that no valid values can be obtained. 
     * @return ApplicationId Application ID.
Note: this field may return null, indicating that no valid values can be obtained.
     */
    public String getApplicationId() {
        return this.ApplicationId;
    }

    /**
     * Set Application ID.
Note: this field may return null, indicating that no valid values can be obtained.
     * @param ApplicationId Application ID.
Note: this field may return null, indicating that no valid values can be obtained.
     */
    public void setApplicationId(String ApplicationId) {
        this.ApplicationId = ApplicationId;
    }

    /**
     * Get Returned list of eligible data.
Note: this field may return null, indicating that no valid values can be obtained. 
     * @return AccountGroupList Returned list of eligible data.
Note: this field may return null, indicating that no valid values can be obtained.
     */
    public AccountGroupInfo [] getAccountGroupList() {
        return this.AccountGroupList;
    }

    /**
     * Set Returned list of eligible data.
Note: this field may return null, indicating that no valid values can be obtained.
     * @param AccountGroupList Returned list of eligible data.
Note: this field may return null, indicating that no valid values can be obtained.
     */
    public void setAccountGroupList(AccountGroupInfo [] AccountGroupList) {
        this.AccountGroupList = AccountGroupList;
    }

    /**
     * Get The unique request ID, which is returned for each request. RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     * @param RequestId The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAccountGroupResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAccountGroupResponse(DescribeAccountGroupResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.ApplicationId != null) {
            this.ApplicationId = new String(source.ApplicationId);
        }
        if (source.AccountGroupList != null) {
            this.AccountGroupList = new AccountGroupInfo[source.AccountGroupList.length];
            for (int i = 0; i < source.AccountGroupList.length; i++) {
                this.AccountGroupList[i] = new AccountGroupInfo(source.AccountGroupList[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamSimple(map, prefix + "ApplicationId", this.ApplicationId);
        this.setParamArrayObj(map, prefix + "AccountGroupList.", this.AccountGroupList);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

