package com.tencentcloudapi.emr.v20190103;
public enum EmrErrorCode {
     /* CAM signature/authentication error. */
     AUTHFAILURE("AuthFailure"),
     
     /* Operation failed. */
     FAILEDOPERATION("FailedOperation"),
     
     /* Operation failed. */
     FAILEDOPERATION_CHECKIFSUPPORTPODSTRETCH("FailedOperation.CheckIfSupportPodStretch"),
     
     /* DB exception. */
     FAILEDOPERATION_DBEXCEPTION("FailedOperation.DBException"),
     
     /* Failed to fetch resource tag. */
     FAILEDOPERATION_DESCRIBERESOURCETAGSFAILED("FailedOperation.DescribeResourceTagsFailed"),
     
     /* Duplicate order. Please check the EMR console. */
     FAILEDOPERATION_DUPLICATEORDERNOTALLOWED("FailedOperation.DuplicateOrderNotAllowed"),
     
     /* Failed to query the CAM role. */
     FAILEDOPERATION_GETCAMROLEFAILED("FailedOperation.GetCamRoleFailed"),
     
     /* Failed to call the CAM service. */
     FAILEDOPERATION_GETCAMSERVERFAILED("FailedOperation.GetCamServerFailed"),
     
     /* Failed to fetch the specifications of the CVM. */
     FAILEDOPERATION_GETCVMCONFIGQUOTAFAILED("FailedOperation.GetCvmConfigQuotaFailed"),
     
     /* Failed to call the CVM service. */
     FAILEDOPERATION_GETCVMSERVERFAILED("FailedOperation.GetCvmServerFailed"),
     
     /* Failed to call the price inquiry center service. */
     FAILEDOPERATION_GETTRADESERVERFAILED("FailedOperation.GetTradeServerFailed"),
     
     /* No more scaling rules are allowed. */
     FAILEDOPERATION_MORESTRATEGYNOTALLOWED("FailedOperation.MoreStrategyNotAllowed"),
     
     /* Unauthorized operation. */
     FAILEDOPERATION_NOTAUTHENTICATED("FailedOperation.NotAuthenticated"),
     
     /* Operation failed. The pods are not supported. */
     FAILEDOPERATION_NOTSUPPORTPOD("FailedOperation.NotSupportPod"),
     
     /* Operation failed. */
     FAILEDOPERATION_REFUNDCVMFAILED("FailedOperation.RefundCvmFailed"),
     
     /* Operation failed. */
     FAILEDOPERATION_SPECDELETEDENYFORAUTOSCALESTRATEGIES("FailedOperation.SpecDeleteDenyForAutoScaleStrategies"),
     
     /* Internal error. */
     INTERNALERROR("InternalError"),
     
     /* An error occurred while calling another service API. */
     INTERNALERROR_ACCOUNTCGWERROR("InternalError.AccountCgwError"),
     
     /* An error occurred while calling another service API. */
     INTERNALERROR_CAMCGWERROR("InternalError.CamCgwError"),
     
     /* An error occurred while calling another service API. */
     INTERNALERROR_CAMERROR("InternalError.CamError"),
     
     /* An error occurred while calling another service API. */
     INTERNALERROR_CBSCGWERROR("InternalError.CbsCgwError"),
     
     /* An error occurred while calling another service API. */
     INTERNALERROR_CBSERROR("InternalError.CbsError"),
     
     /* An error occurred while calling another service API. */
     INTERNALERROR_CDBCGWERROR("InternalError.CdbCgwError"),
     
     /* An error occurred while calling another service API. */
     INTERNALERROR_CDBERROR("InternalError.CdbError"),
     
     /* CVM or CBS resources are insufficient, or the software is invalid. */
     INTERNALERROR_CHECKQUOTAERR("InternalError.CheckQuotaErr"),
     
     /* An error occurred while calling another service API. */
     INTERNALERROR_CONFIGCGWERROR("InternalError.ConfigCgwError"),
     
     /* An error occurred while calling another service API. */
     INTERNALERROR_CVMERROR("InternalError.CvmError"),
     
     /* Database query error. */
     INTERNALERROR_DBQUERYEXCEPTION("InternalError.DBQueryException"),
     
     /* An exception occurred when OpenTSDB is being requested. */
     INTERNALERROR_DOOPENTSDBREQUESTEXCEPTION("InternalError.DoOpenTSDBRequestException"),
     
     /* Error in calling EKS. */
     INTERNALERROR_EKSERROR("InternalError.EKSError"),
     
     /* An error occurred while calling another service API. */
     INTERNALERROR_KMSERROR("InternalError.KmsError"),
     
     /* Failed to request OpenTSDB. */
     INTERNALERROR_OPENTSDBHTTPRETURNCODENOTOK("InternalError.OpenTSDBHttpReturnCodeNotOK"),
     
     /* An error occurred while calling another service API. */
     INTERNALERROR_PROJECTCGWERROR("InternalError.ProjectCgwError"),
     
     /* An error occurred when calling a security group API. */
     INTERNALERROR_SGERROR("InternalError.SgError"),
     
     /* An error occurred while calling TKE. */
     INTERNALERROR_TKEERROR("InternalError.TKEError"),
     
     /* An error occurred while calling another service API. */
     INTERNALERROR_TAGERROR("InternalError.TagError"),
     
     /* An error occurred while calling another service API. */
     INTERNALERROR_TRADECGWERROR("InternalError.TradeCgwError"),
     
     /* An error occurred while calling another service API. */
     INTERNALERROR_VPCCGWERROR("InternalError.VpcCgwError"),
     
     /* An error occurred while calling another service API. */
     INTERNALERROR_VPCERROR("InternalError.VpcError"),
     
     /* An error occurred while calling another service API. */
     INTERNALERROR_WOODSERVERERROR("InternalError.WoodServerError"),
     
     /* Invalid parameter. */
     INVALIDPARAMETER("InvalidParameter"),
     
     /* Parameter error. */
     INVALIDPARAMETER_APPIDRESOURCENOTMATCH("InvalidParameter.AppIdResourceNotMatch"),
     
     /* Invalid CpuType parameter. */
     INVALIDPARAMETER_CPUTYPE("InvalidParameter.CpuType"),
     
     /* Incorrect display policy. */
     INVALIDPARAMETER_DISPLAYSTRATEGYNOTMATCH("InvalidParameter.DisplayStrategyNotMatch"),
     
     /* Parameter error. */
     INVALIDPARAMETER_HALESSMASTERCOUNT("InvalidParameter.HALessMasterCount"),
     
     /* Impala query parameter error. */
     INVALIDPARAMETER_IMPALAQUERYEXCEPTION("InvalidParameter.ImpalaQueryException"),
     
     /* The number of common nodes is invalid. */
     INVALIDPARAMETER_INCORRECTCOMMONCOUNT("InvalidParameter.IncorrectCommonCount"),
     
     /* The number of master nodes is invalid. */
     INVALIDPARAMETER_INCORRECTMASTERCOUNT("InvalidParameter.IncorrectMasterCount"),
     
     /* Invalid `AllNodeResourceSpec`. */
     INVALIDPARAMETER_INVALIDALLNODERESOURCESPEC("InvalidParameter.InvalidAllNodeResourceSpec"),
     
     /* Invalid `AppId`. */
     INVALIDPARAMETER_INVALIDAPPID("InvalidParameter.InvalidAppId"),
     
     /* Invalid auto-renewal flag. */
     INVALIDPARAMETER_INVALIDAUTORENEW("InvalidParameter.InvalidAutoRenew"),
     
     /* Invalid Classification parameter value. */
     INVALIDPARAMETER_INVALIDCLASSIFICATION("InvalidParameter.InvalidClassification"),
     
     /* Invalid ClickHouse cluster. */
     INVALIDPARAMETER_INVALIDCLICKHOUSECLUSTER("InvalidParameter.InvalidClickHouseCluster"),
     
     /* Invalid `ClientToken`. */
     INVALIDPARAMETER_INVALIDCLIENTTOKEN("InvalidParameter.InvalidClientToken"),
     
     /* Invalid parameter: ClusterId. */
     INVALIDPARAMETER_INVALIDCLUSTERID("InvalidParameter.InvalidClusterId"),
     
     /* Invalid parameter. */
     INVALIDPARAMETER_INVALIDCOMMONDISKTYPE("InvalidParameter.InvalidCommonDiskType"),
     
     /* Illegal metric comparison method. */
     INVALIDPARAMETER_INVALIDCOMPAREMETHOD("InvalidParameter.InvalidCompareMethod"),
     
     /* Invalid component. */
     INVALIDPARAMETER_INVALIDCOMPONENT("InvalidParameter.InvalidComponent"),
     
     /* At least one trigger condition is required. */
     INVALIDPARAMETER_INVALIDCONDITIONNUM("InvalidParameter.InvalidConditionNum"),
     
     /* The number of core nodes is invalid. */
     INVALIDPARAMETER_INVALIDCORECOUNT("InvalidParameter.InvalidCoreCount"),
     
     /* Parameter error. */
     INVALIDPARAMETER_INVALIDCOREDISKTYPE("InvalidParameter.InvalidCoreDiskType"),
     
     /* The CosBucket parameter is invalid. */
     INVALIDPARAMETER_INVALIDCOSBUCKET("InvalidParameter.InvalidCosBucket"),
     
     /* The CosFileUri parameter value is invalid. */
     INVALIDPARAMETER_INVALIDCOSFILEURI("InvalidParameter.InvalidCosFileURI"),
     
     /* The count must be greater than 0. */
     INVALIDPARAMETER_INVALIDCOUNT("InvalidParameter.InvalidCount"),
     
     /* A scale-out request only applies to task nodes or core nodes. */
     INVALIDPARAMETER_INVALIDCOUNTNUM("InvalidParameter.InvalidCountNum"),
     
     /* Error message: Invalid PodParameter. */
     INVALIDPARAMETER_INVALIDCUSTOMIZEDPODPARAM("InvalidParameter.InvalidCustomizedPodParam"),
     
     /* Conflict between`DependService` and `EnableKerberos`. */
     INVALIDPARAMETER_INVALIDDEPENDSERVICEANDENABLEKERBEROSCONFLICT("InvalidParameter.InvalidDependServiceAndEnableKerberosConflict"),
     
     /* Invalid number of disks. */
     INVALIDPARAMETER_INVALIDDISKNUM("InvalidParameter.InvalidDiskNum"),
     
     /* Invalid disk size. */
     INVALIDPARAMETER_INVALIDDISKSIZE("InvalidParameter.InvalidDiskSize"),
     
     /* Parameter error. */
     INVALIDPARAMETER_INVALIDDISKTYPE("InvalidParameter.InvalidDiskType"),
     
     /* Invalid EKS instance. */
     INVALIDPARAMETER_INVALIDEKSINSTANCE("InvalidParameter.InvalidEksInstance"),
     
     /* Invalid `CustomConfig`. */
     INVALIDPARAMETER_INVALIDEXTENDFIELD("InvalidParameter.InvalidExtendField"),
     
     /* Invalid filter parameter. */
     INVALIDPARAMETER_INVALIDFILTERKEY("InvalidParameter.InvalidFilterKey"),
     
     /* Invalid instance billing mode. */
     INVALIDPARAMETER_INVALIDINSTANCECHARGETYPE("InvalidParameter.InvalidInstanceChargeType"),
     
     /* Invalid cluster name. */
     INVALIDPARAMETER_INVALIDINSTANCENAME("InvalidParameter.InvalidInstanceName"),
     
     /* Invalid model. */
     INVALIDPARAMETER_INVALIDINSTANCETYPE("InvalidParameter.InvalidInstanceType"),
     
     /* Invalid process task. */
     INVALIDPARAMETER_INVALIDJOBFLOW("InvalidParameter.InvalidJobFlow"),
     
     /* Invalid LoadBalancerId. */
     INVALIDPARAMETER_INVALIDLOADBALANCER("InvalidParameter.InvalidLoadBalancer"),
     
     /* Invalid login settings. */
     INVALIDPARAMETER_INVALIDLOGINSETTING("InvalidParameter.InvalidLoginSetting"),
     
     /* Invalid parameter. */
     INVALIDPARAMETER_INVALIDMASTERDISKTYPE("InvalidParameter.InvalidMasterDiskType"),
     
     /* Invalid metadatabase URL. */
     INVALIDPARAMETER_INVALIDMETADATAJDBCURL("InvalidParameter.InvalidMetaDataJdbcUrl"),
     
     /* Invalid metadata table type. */
     INVALIDPARAMETER_INVALIDMETATYPE("InvalidParameter.InvalidMetaType"),
     
     /* Invalid target specification. */
     INVALIDPARAMETER_INVALIDMODIFYSPEC("InvalidParameter.InvalidModifySpec"),
     
     /* Illegal node count. */
     INVALIDPARAMETER_INVALIDNODECOUNT("InvalidParameter.InvalidNodeCount"),
     
     /* Incorrect node type. */
     INVALIDPARAMETER_INVALIDNODEFLAG("InvalidParameter.InvalidNodeFlag"),
     
     /* Invalid `NodeType`. */
     INVALIDPARAMETER_INVALIDNODETYPE("InvalidParameter.InvalidNodeType"),
     
     /* The SoftInfo parameter is invalid. */
     INVALIDPARAMETER_INVALIDPARAMTERINVALIDSOFTINFO("InvalidParameter.InvalidParamterInvalidSoftInfo"),
     
     /* Invalid password. */
     INVALIDPARAMETER_INVALIDPASSWORD("InvalidParameter.InvalidPassword"),
     
     /* Invalid billing mode. */
     INVALIDPARAMETER_INVALIDPAYMODE("InvalidParameter.InvalidPaymode"),
     
     /* Invalid bootstrap script. */
     INVALIDPARAMETER_INVALIDPREEXECUTEDFILE("InvalidParameter.InvalidPreExecutedFile"),
     
     /* Illegal metric processing method. */
     INVALIDPARAMETER_INVALIDPROCESSMETHOD("InvalidParameter.InvalidProcessMethod"),
     
     /* Invalid product ID. */
     INVALIDPARAMETER_INVALIDPRODUCTID("InvalidParameter.InvalidProductId"),
     
     /* Invalid product version. */
     INVALIDPARAMETER_INVALIDPRODUCTVERSION("InvalidParameter.InvalidProductVersion"),
     
     /* Invalid project ID. */
     INVALIDPARAMETER_INVALIDPROJECTID("InvalidParameter.InvalidProjectId"),
     
     /* Invalid auto-renewal identifier. */
     INVALIDPARAMETER_INVALIDRENEWFLAG("InvalidParameter.InvalidRenewFlag"),
     
     /* Invalid resource ID. */
     INVALIDPARAMETER_INVALIDRESOURCEID("InvalidParameter.InvalidResourceId"),
     
     /* Invalid resource ID. */
     INVALIDPARAMETER_INVALIDRESOURCEIDS("InvalidParameter.InvalidResourceIds"),
     
     /* Invalid resource specification. */
     INVALIDPARAMETER_INVALIDRESOURCESPEC("InvalidParameter.InvalidResourceSpec"),
     
     /* Invalid scaling action. */
     INVALIDPARAMETER_INVALIDSCALEACTION("InvalidParameter.InvalidScaleAction"),
     
     /* Invalid bootstrap script execution parameter. */
     INVALIDPARAMETER_INVALIDSCRIPTBOOTSTRAPACTIONCONFIG("InvalidParameter.InvalidScriptBootstrapActionConfig"),
     
     /* This EMR version does not support the security mode. */
     INVALIDPARAMETER_INVALIDSECURITYSUPPORT("InvalidParameter.InvalidSecuritySupport"),
     
     /* Invalid security group ID. */
     INVALIDPARAMETER_INVALIDSERCURITYGRPUPID("InvalidParameter.InvalidSercurityGrpupId"),
     
     /* The service name is invalid. */
     INVALIDPARAMETER_INVALIDSERVICENAME("InvalidParameter.InvalidServiceName"),
     
     /* The `ServiceNodeInfo` parameter is invalid or incorrect. */
     INVALIDPARAMETER_INVALIDSERVICENODEINFO("InvalidParameter.InvalidServiceNodeInfo"),
     
     /* The `InvalidSoftDeployInfo` parameter is invalid or incorrect. */
     INVALIDPARAMETER_INVALIDSOFTDEPLOYINFO("InvalidParameter.InvalidSoftDeployInfo"),
     
     /* Invalid `SoftInfo`. */
     INVALIDPARAMETER_INVALIDSOFTINFO("InvalidParameter.InvalidSoftInfo"),
     
     /* Incorrect parameter. */
     INVALIDPARAMETER_INVALIDSOFTWARE("InvalidParameter.InvalidSoftWare"),
     
     /* The software name is invalid. */
     INVALIDPARAMETER_INVALIDSOFTWARENAME("InvalidParameter.InvalidSoftWareName"),
     
     /* The software version is invalid. */
     INVALIDPARAMETER_INVALIDSOFTWAREVERSION("InvalidParameter.InvalidSoftWareVersion"),
     
     /* Invalid `StartTime` or `EndTime` parameter. */
     INVALIDPARAMETER_INVALIDSTARTTIMEORENDTIME("InvalidParameter.InvalidStartTimeOrEndTime"),
     
     /* The StatisticPeriod or TriggerThreshold parameter is invalid. */
     INVALIDPARAMETER_INVALIDSTATISTICPERIODORTRIGGERTHRESHOLD("InvalidParameter.InvalidStatisticPeriodOrTriggerThreshold"),
     
     /* Parameter error. */
     INVALIDPARAMETER_INVALIDSTRATEGY("InvalidParameter.InvalidStrategy"),
     
     /* Invalid rule priority. */
     INVALIDPARAMETER_INVALIDSTRATEGYPRIORITY("InvalidParameter.InvalidStrategyPriority"),
     
     /* Invalid specification. */
     INVALIDPARAMETER_INVALIDSTRATEGYSPEC("InvalidParameter.InvalidStrategySpec"),
     
     /* Unsupported scaling policy type. */
     INVALIDPARAMETER_INVALIDSTRATEGYTYPE("InvalidParameter.InvalidStrategyType"),
     
     /* Invalid subnet ID. */
     INVALIDPARAMETER_INVALIDSUBNETID("InvalidParameter.InvalidSubnetId"),
     
     /* Invalid high availability parameter. */
     INVALIDPARAMETER_INVALIDSUPPORTHA("InvalidParameter.InvalidSupportHA"),
     
     /* The number of task nodes cannot exceed 20. */
     INVALIDPARAMETER_INVALIDTASKCOUNT("InvalidParameter.InvalidTaskCount"),
     
     /* Parameter error. */
     INVALIDPARAMETER_INVALIDTIMELAYOUT("InvalidParameter.InvalidTimeLayout"),
     
     /* Invalid `timespan`. */
     INVALIDPARAMETER_INVALIDTIMESPAN("InvalidParameter.InvalidTimeSpan"),
     
     /* Invalid `TimeUnit`. */
     INVALIDPARAMETER_INVALIDTIMEUNIT("InvalidParameter.InvalidTimeUnit"),
     
     /* The TKE cluster ID is invalid, or the TKE cluster is not eligible. */
     INVALIDPARAMETER_INVALIDTKEINSTANCE("InvalidParameter.InvalidTkeInstance"),
     
     /* Parent account UIN parameter input error. */
     INVALIDPARAMETER_INVALIDUINNUM("InvalidParameter.InvalidUinNum"),
     
     /* Invalid unified metadatabase. */
     INVALIDPARAMETER_INVALIDUNIFYMETA("InvalidParameter.InvalidUnifyMeta"),
     
     /* Parameter error. */
     INVALIDPARAMETER_INVALIDVENDORTYPE("InvalidParameter.InvalidVendorType"),
     
     /* Parameter error. */
     INVALIDPARAMETER_INVALIDVOLUMETYPE("InvalidParameter.InvalidVolumeType"),
     
     /* Invalid VPC ID. */
     INVALIDPARAMETER_INVALIDVPCID("InvalidParameter.InvalidVpcId"),
     
     /* Invalid AZ. */
     INVALIDPARAMETER_INVALIDZONE("InvalidParameter.InvalidZone"),
     
     /* Invalid identifier for Kerberos support. */
     INVALIDPARAMETER_KERBEROSSUPPORT("InvalidParameter.KerberosSupport"),
     
     /* Parameter error. */
     INVALIDPARAMETER_LESSCOMMONCOUNT("InvalidParameter.LessCommonCount"),
     
     /* Parameter error. */
     INVALIDPARAMETER_LESSTASKCOUNT("InvalidParameter.LessTaskCount"),
     
     /* Number of CVM instances exceeds the maximum limit. */
     INVALIDPARAMETER_MOREMAXLIMITNUM("InvalidParameter.MoreMaxlimitNum"),
     
     /* Invalid parameter. Necessary components are missing. */
     INVALIDPARAMETER_NOTCONTAINMUSTSELECTSOFTWARE("InvalidParameter.NotContainMustSelectSoftware"),
     
     /* Invalid sorting field. */
     INVALIDPARAMETER_ORDERFIELDNOTMATCH("InvalidParameter.OrderFieldNotMatch"),
     
     /* The billing mode and resource do not match. */
     INVALIDPARAMETER_PAYMODERESOURCENOTMATCH("InvalidParameter.PayModeResourceNotMatch"),
     
     /* The project does not match the resource. */
     INVALIDPARAMETER_PROJECTRESOURCENOTMATCH("InvalidParameter.ProjectResourceNotMatch"),
     
     /* Duplicate execution time. */
     INVALIDPARAMETER_REPEATEDEXECUTIONTIME("InvalidParameter.RepeatedExecutionTime"),
     
     /* Repeated scaling rule name. */
     INVALIDPARAMETER_REPEATEDSTRATEGYNAME("InvalidParameter.RepeatedStrategyName"),
     
     /* Invalid ResourceProviderType parameter. */
     INVALIDPARAMETER_RESOURCEPROVIDERTYPE("InvalidParameter.ResourceProviderType"),
     
     /* This service does not support restart. */
     INVALIDPARAMETER_RESTARTSERVICEUNSUPPORTED("InvalidParameter.RestartServiceUnsupported"),
     
     /* Invalid product component exists. */
     INVALIDPARAMETER_SOFTWARENOTINPRODUCR("InvalidParameter.SoftwareNotInProducr"),
     
     /* There is an invalid product component. */
     INVALIDPARAMETER_SOFTWARENOTINPRODUCT("InvalidParameter.SoftwareNotInProduct"),
     
     /* The policy is not authorized. */
     INVALIDPARAMETER_UNGRANTEDPOLICY("InvalidParameter.UngrantedPolicy"),
     
     /* The role is not authorized. */
     INVALIDPARAMETER_UNGRANTEDROLE("InvalidParameter.UngrantedRole"),
     
     /* Parameter error. */
     INVALIDPARAMETER_UNSATISFIEDSOFTDEPENDECY("InvalidParameter.UnsatisfiedSoftDependecy"),
     
     /* The AZ and resource do not match. */
     INVALIDPARAMETER_ZONERESOURCENOTMATCH("InvalidParameter.ZoneResourceNotMatch"),
     
     /* Incorrect parameter value. */
     INVALIDPARAMETERVALUE("InvalidParameterValue"),
     
     /* The TKE cluster ID is invalid, or the TKE cluster is not eligible. */
     INVALIDPARAMETERVALUE_INVALIDTKEINSTANCE("InvalidParameterValue.InvalidTkeInstance"),
     
     /* The quota limit is exceeded. */
     LIMITEXCEEDED("LimitExceeded"),
     
     /* Request backlogs have exceeded the limit. */
     LIMITEXCEEDED_REQUESTBACKLOGEXCEEDSLIMIT("LimitExceeded.RequestBacklogExceedsLimit"),
     
     /* The number of security groups exceeds the limit. */
     LIMITEXCEEDED_SECURITYGROUPNUMLIMITEXCEEDED("LimitExceeded.SecurityGroupNumLimitExceeded"),
     
     /* Number of users exceeds the limit. */
     LIMITEXCEEDED_USERCOUNTEXCEEDSLIMIT("LimitExceeded.UserCountExceedsLimit"),
     
     /* Missing parameter. */
     MISSINGPARAMETER("MissingParameter"),
     
     /* Error of misiParameter errors are missing. */
     MISSINGPARAMETER_MISSINGCORERESOURCE("MissingParameter.MissingCoreResource"),
     
     /* Operation denied. */
     OPERATIONDENIED("OperationDenied"),
     
     /* Number of requests exceeds the frequency limit. */
     REQUESTLIMITEXCEEDED("RequestLimitExceeded"),
     
     /* The instance is under workflow. */
     RESOURCEINUSE_INSTANCEINPROCESS("ResourceInUse.InstanceInProcess"),
     
     /* The disk specification is insufficient. */
     RESOURCEINSUFFICIENT_DISKINSUFFICIENT("ResourceInsufficient.DiskInsufficient"),
     
     /* The node specification is unsupported or has been sold out. */
     RESOURCEINSUFFICIENT_INSTANCEINSUFFICIENT("ResourceInsufficient.InstanceInsufficient"),
     
     /* Resources do not exist. */
     RESOURCENOTFOUND("ResourceNotFound"),
     
     /* The instance was not found. */
     RESOURCENOTFOUND_CLUSTERNOTFOUND("ResourceNotFound.ClusterNotFound"),
     
     /* Unable to find the specified CVM instance. */
     RESOURCENOTFOUND_CVMINSTANCENOTFOUND("ResourceNotFound.CvmInstanceNotFound"),
     
     /* No hardware information found. */
     RESOURCENOTFOUND_HARDWAREINFONOTFOUND("ResourceNotFound.HardwareInfoNotFound"),
     
     /* The instance was not found. */
     RESOURCENOTFOUND_INSTANCENOTFOUND("ResourceNotFound.InstanceNotFound"),
     
     /* Unable to find the monitoring metadata. */
     RESOURCENOTFOUND_RESOURCENOTFOUND("ResourceNotFound.ResourceNotFound"),
     
     /* The specifications do not exist. */
     RESOURCENOTFOUND_SPECNOTFOUND("ResourceNotFound.SpecNotFound"),
     
     /* Corresponding scaling rules not found. */
     RESOURCENOTFOUND_STRATEGYNOTFOUND("ResourceNotFound.StrategyNotFound"),
     
     /* No corresponding subnet found. */
     RESOURCENOTFOUND_SUBNETNOTFOUND("ResourceNotFound.SubnetNotFound"),
     
     /* Preset components of the TKE cluster are not deployed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   */
     RESOURCENOTFOUND_TKEPRECONDITIONNOTFOUND("ResourceNotFound.TKEPreconditionNotFound"),
     
     /* No specified tag found. */
     RESOURCENOTFOUND_TAGSNOTFOUND("ResourceNotFound.TagsNotFound"),
     
     /* Resources are unavailable. */
     RESOURCEUNAVAILABLE_NOTSUPPORTNODETYPE("ResourceUnavailable.NotSupportNodeType"),
     
     /* Resources are unavailable. */
     RESOURCEUNAVAILABLE_NOTSUPPORTRESOURCETYPE("ResourceUnavailable.NotSupportResourceType"),
     
     /* Duplicate resource specifications. */
     RESOURCEUNAVAILABLE_REPEATSPEC("ResourceUnavailable.RepeatSpec"),
     
     /* There is no default value of the current resource spec. */
     RESOURCEUNAVAILABLE_RESOURCESPECNOTDEFAULTSPEC("ResourceUnavailable.ResourceSpecNotDefaultSpec"),
     
     /* The resource specification does not exist. */
     RESOURCEUNAVAILABLE_RESOURCESPECNOTEXIST("ResourceUnavailable.ResourceSpecNotExist"),
     
     /* The resources have been sold out. */
     RESOURCESSOLDOUT("ResourcesSoldOut"),
     
     /* The CBS resources have been sold out. */
     RESOURCESSOLDOUT_CBSSOLDOUT("ResourcesSoldOut.CbsSoldOut"),
     
     /* CVM instances have been sold out. */
     RESOURCESSOLDOUT_CVMSOLDOUT("ResourcesSoldOut.CvmSoldOut"),
     
     /* Unauthorized operation. */
     UNAUTHORIZEDOPERATION("UnauthorizedOperation"),
     
     /* The `appId` is inconsistent. */
     UNAUTHORIZEDOPERATION_APPIDMISMATCHED("UnauthorizedOperation.AppIdMismatched"),
     
     /* Unauthorized operation. */
     UNAUTHORIZEDOPERATION_CHECKCAMAUTH("UnauthorizedOperation.CheckCamAuth"),
     
     /* Unknown parameter. */
     UNKNOWNPARAMETER("UnknownParameter"),
     
     /* Unsupported operation. */
     UNSUPPORTEDOPERATION("UnsupportedOperation"),
     
     /* This function is included in the allowlist. */
     UNSUPPORTEDOPERATION_NOTINWHITELIST("UnsupportedOperation.NotInWhiteList"),
     
     /* This operation is not supported. */
     UNSUPPORTEDOPERATION_SERVICENOTSUPPORT("UnsupportedOperation.ServiceNotSupport");
     
    private String value;
    private EmrErrorCode (String value){
        this.value = value;
    }
    /**
     * @return errorcode value
     */
    public String getValue() {
        return value;
    }
}

