/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ConfigurationItem extends AbstractModel {

    /**
    * Configuration item name.
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
    * Configuration item value.
    */
    @SerializedName("Value")
    @Expose
    private String Value;

    /**
    * Name of the configuration file where the configuration item is located.
    */
    @SerializedName("InFile")
    @Expose
    private String InFile;

    /**
     * Get Configuration item name. 
     * @return Name Configuration item name.
     */
    public String getName() {
        return this.Name;
    }

    /**
     * Set Configuration item name.
     * @param Name Configuration item name.
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    /**
     * Get Configuration item value. 
     * @return Value Configuration item value.
     */
    public String getValue() {
        return this.Value;
    }

    /**
     * Set Configuration item value.
     * @param Value Configuration item value.
     */
    public void setValue(String Value) {
        this.Value = Value;
    }

    /**
     * Get Name of the configuration file where the configuration item is located. 
     * @return InFile Name of the configuration file where the configuration item is located.
     */
    public String getInFile() {
        return this.InFile;
    }

    /**
     * Set Name of the configuration file where the configuration item is located.
     * @param InFile Name of the configuration file where the configuration item is located.
     */
    public void setInFile(String InFile) {
        this.InFile = InFile;
    }

    public ConfigurationItem() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ConfigurationItem(ConfigurationItem source) {
        if (source.Name != null) {
            this.Name = new String(source.Name);
        }
        if (source.Value != null) {
            this.Value = new String(source.Value);
        }
        if (source.InFile != null) {
            this.InFile = new String(source.InFile);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Name", this.Name);
        this.setParamSimple(map, prefix + "Value", this.Value);
        this.setParamSimple(map, prefix + "InFile", this.InFile);

    }
}

