/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAutoScaleStrategiesResponse extends AbstractModel {

    /**
    * Load-based scaling rules

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("LoadAutoScaleStrategies")
    @Expose
    private LoadAutoScaleStrategy [] LoadAutoScaleStrategies;

    /**
    * Scaling rules by time

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("TimeBasedAutoScaleStrategies")
    @Expose
    private TimeAutoScaleStrategy [] TimeBasedAutoScaleStrategies;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Load-based scaling rules

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return LoadAutoScaleStrategies Load-based scaling rules

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public LoadAutoScaleStrategy [] getLoadAutoScaleStrategies() {
        return this.LoadAutoScaleStrategies;
    }

    /**
     * Set Load-based scaling rules

Note: This field may return null, indicating that no valid values can be obtained.
     * @param LoadAutoScaleStrategies Load-based scaling rules

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setLoadAutoScaleStrategies(LoadAutoScaleStrategy [] LoadAutoScaleStrategies) {
        this.LoadAutoScaleStrategies = LoadAutoScaleStrategies;
    }

    /**
     * Get Scaling rules by time

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return TimeBasedAutoScaleStrategies Scaling rules by time

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public TimeAutoScaleStrategy [] getTimeBasedAutoScaleStrategies() {
        return this.TimeBasedAutoScaleStrategies;
    }

    /**
     * Set Scaling rules by time

Note: This field may return null, indicating that no valid values can be obtained.
     * @param TimeBasedAutoScaleStrategies Scaling rules by time

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setTimeBasedAutoScaleStrategies(TimeAutoScaleStrategy [] TimeBasedAutoScaleStrategies) {
        this.TimeBasedAutoScaleStrategies = TimeBasedAutoScaleStrategies;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAutoScaleStrategiesResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAutoScaleStrategiesResponse(DescribeAutoScaleStrategiesResponse source) {
        if (source.LoadAutoScaleStrategies != null) {
            this.LoadAutoScaleStrategies = new LoadAutoScaleStrategy[source.LoadAutoScaleStrategies.length];
            for (int i = 0; i < source.LoadAutoScaleStrategies.length; i++) {
                this.LoadAutoScaleStrategies[i] = new LoadAutoScaleStrategy(source.LoadAutoScaleStrategies[i]);
            }
        }
        if (source.TimeBasedAutoScaleStrategies != null) {
            this.TimeBasedAutoScaleStrategies = new TimeAutoScaleStrategy[source.TimeBasedAutoScaleStrategies.length];
            for (int i = 0; i < source.TimeBasedAutoScaleStrategies.length; i++) {
                this.TimeBasedAutoScaleStrategies[i] = new TimeAutoScaleStrategy(source.TimeBasedAutoScaleStrategies[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "LoadAutoScaleStrategies.", this.LoadAutoScaleStrategies);
        this.setParamArrayObj(map, prefix + "TimeBasedAutoScaleStrategies.", this.TimeBasedAutoScaleStrategies);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

