/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeClusterFlowStatusDetailResponse extends AbstractModel {

    /**
    * Task step details

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("StageDetails")
    @Expose
    private StageInfoDetail [] StageDetails;

    /**
    * Task parameters.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("FlowDesc")
    @Expose
    private FlowParamsDesc [] FlowDesc;

    /**
    * Task name.
    */
    @SerializedName("FlowName")
    @Expose
    private String FlowName;

    /**
    * Overall task flow progress.
Example: 0.8.
    */
    @SerializedName("FlowTotalProgress")
    @Expose
    private Float FlowTotalProgress;

    /**
    * Overall process status definition.
0: initializing.
1: running.
2: completed.
3: completed (with skipped steps).
-1: failed.
-3: blocked.
    */
    @SerializedName("FlowTotalStatus")
    @Expose
    private Long FlowTotalStatus;

    /**
    * Additional process information.
This parameter is returned when NeedExtraDetail is true.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("FlowExtraDetail")
    @Expose
    private FlowExtraDetail [] FlowExtraDetail;

    /**
    * Flow description.
    */
    @SerializedName("FlowInfo")
    @Expose
    private String FlowInfo;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Task step details

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return StageDetails Task step details

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public StageInfoDetail [] getStageDetails() {
        return this.StageDetails;
    }

    /**
     * Set Task step details

Note: This field may return null, indicating that no valid values can be obtained.
     * @param StageDetails Task step details

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setStageDetails(StageInfoDetail [] StageDetails) {
        this.StageDetails = StageDetails;
    }

    /**
     * Get Task parameters.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return FlowDesc Task parameters.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public FlowParamsDesc [] getFlowDesc() {
        return this.FlowDesc;
    }

    /**
     * Set Task parameters.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param FlowDesc Task parameters.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setFlowDesc(FlowParamsDesc [] FlowDesc) {
        this.FlowDesc = FlowDesc;
    }

    /**
     * Get Task name. 
     * @return FlowName Task name.
     */
    public String getFlowName() {
        return this.FlowName;
    }

    /**
     * Set Task name.
     * @param FlowName Task name.
     */
    public void setFlowName(String FlowName) {
        this.FlowName = FlowName;
    }

    /**
     * Get Overall task flow progress.
Example: 0.8. 
     * @return FlowTotalProgress Overall task flow progress.
Example: 0.8.
     */
    public Float getFlowTotalProgress() {
        return this.FlowTotalProgress;
    }

    /**
     * Set Overall task flow progress.
Example: 0.8.
     * @param FlowTotalProgress Overall task flow progress.
Example: 0.8.
     */
    public void setFlowTotalProgress(Float FlowTotalProgress) {
        this.FlowTotalProgress = FlowTotalProgress;
    }

    /**
     * Get Overall process status definition.
0: initializing.
1: running.
2: completed.
3: completed (with skipped steps).
-1: failed.
-3: blocked. 
     * @return FlowTotalStatus Overall process status definition.
0: initializing.
1: running.
2: completed.
3: completed (with skipped steps).
-1: failed.
-3: blocked.
     */
    public Long getFlowTotalStatus() {
        return this.FlowTotalStatus;
    }

    /**
     * Set Overall process status definition.
0: initializing.
1: running.
2: completed.
3: completed (with skipped steps).
-1: failed.
-3: blocked.
     * @param FlowTotalStatus Overall process status definition.
0: initializing.
1: running.
2: completed.
3: completed (with skipped steps).
-1: failed.
-3: blocked.
     */
    public void setFlowTotalStatus(Long FlowTotalStatus) {
        this.FlowTotalStatus = FlowTotalStatus;
    }

    /**
     * Get Additional process information.
This parameter is returned when NeedExtraDetail is true.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return FlowExtraDetail Additional process information.
This parameter is returned when NeedExtraDetail is true.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public FlowExtraDetail [] getFlowExtraDetail() {
        return this.FlowExtraDetail;
    }

    /**
     * Set Additional process information.
This parameter is returned when NeedExtraDetail is true.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param FlowExtraDetail Additional process information.
This parameter is returned when NeedExtraDetail is true.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setFlowExtraDetail(FlowExtraDetail [] FlowExtraDetail) {
        this.FlowExtraDetail = FlowExtraDetail;
    }

    /**
     * Get Flow description. 
     * @return FlowInfo Flow description.
     */
    public String getFlowInfo() {
        return this.FlowInfo;
    }

    /**
     * Set Flow description.
     * @param FlowInfo Flow description.
     */
    public void setFlowInfo(String FlowInfo) {
        this.FlowInfo = FlowInfo;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeClusterFlowStatusDetailResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeClusterFlowStatusDetailResponse(DescribeClusterFlowStatusDetailResponse source) {
        if (source.StageDetails != null) {
            this.StageDetails = new StageInfoDetail[source.StageDetails.length];
            for (int i = 0; i < source.StageDetails.length; i++) {
                this.StageDetails[i] = new StageInfoDetail(source.StageDetails[i]);
            }
        }
        if (source.FlowDesc != null) {
            this.FlowDesc = new FlowParamsDesc[source.FlowDesc.length];
            for (int i = 0; i < source.FlowDesc.length; i++) {
                this.FlowDesc[i] = new FlowParamsDesc(source.FlowDesc[i]);
            }
        }
        if (source.FlowName != null) {
            this.FlowName = new String(source.FlowName);
        }
        if (source.FlowTotalProgress != null) {
            this.FlowTotalProgress = new Float(source.FlowTotalProgress);
        }
        if (source.FlowTotalStatus != null) {
            this.FlowTotalStatus = new Long(source.FlowTotalStatus);
        }
        if (source.FlowExtraDetail != null) {
            this.FlowExtraDetail = new FlowExtraDetail[source.FlowExtraDetail.length];
            for (int i = 0; i < source.FlowExtraDetail.length; i++) {
                this.FlowExtraDetail[i] = new FlowExtraDetail(source.FlowExtraDetail[i]);
            }
        }
        if (source.FlowInfo != null) {
            this.FlowInfo = new String(source.FlowInfo);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "StageDetails.", this.StageDetails);
        this.setParamArrayObj(map, prefix + "FlowDesc.", this.FlowDesc);
        this.setParamSimple(map, prefix + "FlowName", this.FlowName);
        this.setParamSimple(map, prefix + "FlowTotalProgress", this.FlowTotalProgress);
        this.setParamSimple(map, prefix + "FlowTotalStatus", this.FlowTotalStatus);
        this.setParamArrayObj(map, prefix + "FlowExtraDetail.", this.FlowExtraDetail);
        this.setParamSimple(map, prefix + "FlowInfo", this.FlowInfo);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

