/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeClusterNodesRequest extends AbstractModel {

    /**
    * Cluster instance ID in the format of emr-xxxxxxxx
    */
    @SerializedName("InstanceId")
    @Expose
    private String InstanceId;

    /**
    * Node flag. Valid values:
<li>all: gets the information of nodes in all types except TencentDB information.</li>
<li>master: gets master node information.</li>
<li>core: gets core node information.</li>
<li>task: gets task node information.</li>
<li>common: gets common node information.</li>
<li>router: gets router node information.</li>
<li>db: gets TencentDB information in normal status.</li>
Note: only the above values are supported for the time being. Entering other values will cause errors.
    */
    @SerializedName("NodeFlag")
    @Expose
    private String NodeFlag;

    /**
    * Whether to carry CDB information when all node information is exported in CSV format.
    */
    @SerializedName("ExportDb")
    @Expose
    private Boolean ExportDb;

    /**
    * Page number. Default value: 0, indicating the first page.
    */
    @SerializedName("Offset")
    @Expose
    private Long Offset;

    /**
    * Number of records to be returned per page. The default value is 100, and the maximum value is 100.
If both offset and limit are not set, or both are set to 0, all data will be returned.
    */
    @SerializedName("Limit")
    @Expose
    private Long Limit;

    /**
    * Resource type. Valid values: all, host, pod. Default value: all
    */
    @SerializedName("HardwareResourceType")
    @Expose
    private String HardwareResourceType;

    /**
    * Searchable field
    */
    @SerializedName("SearchFields")
    @Expose
    private SearchItem [] SearchFields;

    /**
    * Order field.
    */
    @SerializedName("OrderField")
    @Expose
    private String OrderField;

    /**
    * Ascending or not. 1: ascending; 0: descending.
    */
    @SerializedName("Asc")
    @Expose
    private Long Asc;

    /**
     * Get Cluster instance ID in the format of emr-xxxxxxxx 
     * @return InstanceId Cluster instance ID in the format of emr-xxxxxxxx
     */
    public String getInstanceId() {
        return this.InstanceId;
    }

    /**
     * Set Cluster instance ID in the format of emr-xxxxxxxx
     * @param InstanceId Cluster instance ID in the format of emr-xxxxxxxx
     */
    public void setInstanceId(String InstanceId) {
        this.InstanceId = InstanceId;
    }

    /**
     * Get Node flag. Valid values:
<li>all: gets the information of nodes in all types except TencentDB information.</li>
<li>master: gets master node information.</li>
<li>core: gets core node information.</li>
<li>task: gets task node information.</li>
<li>common: gets common node information.</li>
<li>router: gets router node information.</li>
<li>db: gets TencentDB information in normal status.</li>
Note: only the above values are supported for the time being. Entering other values will cause errors. 
     * @return NodeFlag Node flag. Valid values:
<li>all: gets the information of nodes in all types except TencentDB information.</li>
<li>master: gets master node information.</li>
<li>core: gets core node information.</li>
<li>task: gets task node information.</li>
<li>common: gets common node information.</li>
<li>router: gets router node information.</li>
<li>db: gets TencentDB information in normal status.</li>
Note: only the above values are supported for the time being. Entering other values will cause errors.
     */
    public String getNodeFlag() {
        return this.NodeFlag;
    }

    /**
     * Set Node flag. Valid values:
<li>all: gets the information of nodes in all types except TencentDB information.</li>
<li>master: gets master node information.</li>
<li>core: gets core node information.</li>
<li>task: gets task node information.</li>
<li>common: gets common node information.</li>
<li>router: gets router node information.</li>
<li>db: gets TencentDB information in normal status.</li>
Note: only the above values are supported for the time being. Entering other values will cause errors.
     * @param NodeFlag Node flag. Valid values:
<li>all: gets the information of nodes in all types except TencentDB information.</li>
<li>master: gets master node information.</li>
<li>core: gets core node information.</li>
<li>task: gets task node information.</li>
<li>common: gets common node information.</li>
<li>router: gets router node information.</li>
<li>db: gets TencentDB information in normal status.</li>
Note: only the above values are supported for the time being. Entering other values will cause errors.
     */
    public void setNodeFlag(String NodeFlag) {
        this.NodeFlag = NodeFlag;
    }

    /**
     * Get Whether to carry CDB information when all node information is exported in CSV format. 
     * @return ExportDb Whether to carry CDB information when all node information is exported in CSV format.
     */
    public Boolean getExportDb() {
        return this.ExportDb;
    }

    /**
     * Set Whether to carry CDB information when all node information is exported in CSV format.
     * @param ExportDb Whether to carry CDB information when all node information is exported in CSV format.
     */
    public void setExportDb(Boolean ExportDb) {
        this.ExportDb = ExportDb;
    }

    /**
     * Get Page number. Default value: 0, indicating the first page. 
     * @return Offset Page number. Default value: 0, indicating the first page.
     */
    public Long getOffset() {
        return this.Offset;
    }

    /**
     * Set Page number. Default value: 0, indicating the first page.
     * @param Offset Page number. Default value: 0, indicating the first page.
     */
    public void setOffset(Long Offset) {
        this.Offset = Offset;
    }

    /**
     * Get Number of records to be returned per page. The default value is 100, and the maximum value is 100.
If both offset and limit are not set, or both are set to 0, all data will be returned. 
     * @return Limit Number of records to be returned per page. The default value is 100, and the maximum value is 100.
If both offset and limit are not set, or both are set to 0, all data will be returned.
     */
    public Long getLimit() {
        return this.Limit;
    }

    /**
     * Set Number of records to be returned per page. The default value is 100, and the maximum value is 100.
If both offset and limit are not set, or both are set to 0, all data will be returned.
     * @param Limit Number of records to be returned per page. The default value is 100, and the maximum value is 100.
If both offset and limit are not set, or both are set to 0, all data will be returned.
     */
    public void setLimit(Long Limit) {
        this.Limit = Limit;
    }

    /**
     * Get Resource type. Valid values: all, host, pod. Default value: all 
     * @return HardwareResourceType Resource type. Valid values: all, host, pod. Default value: all
     */
    public String getHardwareResourceType() {
        return this.HardwareResourceType;
    }

    /**
     * Set Resource type. Valid values: all, host, pod. Default value: all
     * @param HardwareResourceType Resource type. Valid values: all, host, pod. Default value: all
     */
    public void setHardwareResourceType(String HardwareResourceType) {
        this.HardwareResourceType = HardwareResourceType;
    }

    /**
     * Get Searchable field 
     * @return SearchFields Searchable field
     */
    public SearchItem [] getSearchFields() {
        return this.SearchFields;
    }

    /**
     * Set Searchable field
     * @param SearchFields Searchable field
     */
    public void setSearchFields(SearchItem [] SearchFields) {
        this.SearchFields = SearchFields;
    }

    /**
     * Get Order field. 
     * @return OrderField Order field.
     */
    public String getOrderField() {
        return this.OrderField;
    }

    /**
     * Set Order field.
     * @param OrderField Order field.
     */
    public void setOrderField(String OrderField) {
        this.OrderField = OrderField;
    }

    /**
     * Get Ascending or not. 1: ascending; 0: descending. 
     * @return Asc Ascending or not. 1: ascending; 0: descending.
     */
    public Long getAsc() {
        return this.Asc;
    }

    /**
     * Set Ascending or not. 1: ascending; 0: descending.
     * @param Asc Ascending or not. 1: ascending; 0: descending.
     */
    public void setAsc(Long Asc) {
        this.Asc = Asc;
    }

    public DescribeClusterNodesRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeClusterNodesRequest(DescribeClusterNodesRequest source) {
        if (source.InstanceId != null) {
            this.InstanceId = new String(source.InstanceId);
        }
        if (source.NodeFlag != null) {
            this.NodeFlag = new String(source.NodeFlag);
        }
        if (source.ExportDb != null) {
            this.ExportDb = new Boolean(source.ExportDb);
        }
        if (source.Offset != null) {
            this.Offset = new Long(source.Offset);
        }
        if (source.Limit != null) {
            this.Limit = new Long(source.Limit);
        }
        if (source.HardwareResourceType != null) {
            this.HardwareResourceType = new String(source.HardwareResourceType);
        }
        if (source.SearchFields != null) {
            this.SearchFields = new SearchItem[source.SearchFields.length];
            for (int i = 0; i < source.SearchFields.length; i++) {
                this.SearchFields[i] = new SearchItem(source.SearchFields[i]);
            }
        }
        if (source.OrderField != null) {
            this.OrderField = new String(source.OrderField);
        }
        if (source.Asc != null) {
            this.Asc = new Long(source.Asc);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "InstanceId", this.InstanceId);
        this.setParamSimple(map, prefix + "NodeFlag", this.NodeFlag);
        this.setParamSimple(map, prefix + "ExportDb", this.ExportDb);
        this.setParamSimple(map, prefix + "Offset", this.Offset);
        this.setParamSimple(map, prefix + "Limit", this.Limit);
        this.setParamSimple(map, prefix + "HardwareResourceType", this.HardwareResourceType);
        this.setParamArrayObj(map, prefix + "SearchFields.", this.SearchFields);
        this.setParamSimple(map, prefix + "OrderField", this.OrderField);
        this.setParamSimple(map, prefix + "Asc", this.Asc);

    }
}

