/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeGlobalConfigResponse extends AbstractModel {

    /**
    * Whether the resource scheduling feature is enabled.
    */
    @SerializedName("EnableResourceSchedule")
    @Expose
    private Boolean EnableResourceSchedule;

    /**
    * Currently effective resource scheduler.
    */
    @SerializedName("ActiveScheduler")
    @Expose
    private String ActiveScheduler;

    /**
    * Information of the fair scheduler.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("CapacityGlobalConfig")
    @Expose
    private CapacityGlobalConfig CapacityGlobalConfig;

    /**
    * Information of the capacity scheduler.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("FairGlobalConfig")
    @Expose
    private FairGlobalConfig FairGlobalConfig;

    /**
    * Latest resource scheduler.
    */
    @SerializedName("Scheduler")
    @Expose
    private String Scheduler;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Whether the resource scheduling feature is enabled. 
     * @return EnableResourceSchedule Whether the resource scheduling feature is enabled.
     */
    public Boolean getEnableResourceSchedule() {
        return this.EnableResourceSchedule;
    }

    /**
     * Set Whether the resource scheduling feature is enabled.
     * @param EnableResourceSchedule Whether the resource scheduling feature is enabled.
     */
    public void setEnableResourceSchedule(Boolean EnableResourceSchedule) {
        this.EnableResourceSchedule = EnableResourceSchedule;
    }

    /**
     * Get Currently effective resource scheduler. 
     * @return ActiveScheduler Currently effective resource scheduler.
     */
    public String getActiveScheduler() {
        return this.ActiveScheduler;
    }

    /**
     * Set Currently effective resource scheduler.
     * @param ActiveScheduler Currently effective resource scheduler.
     */
    public void setActiveScheduler(String ActiveScheduler) {
        this.ActiveScheduler = ActiveScheduler;
    }

    /**
     * Get Information of the fair scheduler.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return CapacityGlobalConfig Information of the fair scheduler.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public CapacityGlobalConfig getCapacityGlobalConfig() {
        return this.CapacityGlobalConfig;
    }

    /**
     * Set Information of the fair scheduler.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param CapacityGlobalConfig Information of the fair scheduler.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setCapacityGlobalConfig(CapacityGlobalConfig CapacityGlobalConfig) {
        this.CapacityGlobalConfig = CapacityGlobalConfig;
    }

    /**
     * Get Information of the capacity scheduler.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return FairGlobalConfig Information of the capacity scheduler.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public FairGlobalConfig getFairGlobalConfig() {
        return this.FairGlobalConfig;
    }

    /**
     * Set Information of the capacity scheduler.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param FairGlobalConfig Information of the capacity scheduler.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setFairGlobalConfig(FairGlobalConfig FairGlobalConfig) {
        this.FairGlobalConfig = FairGlobalConfig;
    }

    /**
     * Get Latest resource scheduler. 
     * @return Scheduler Latest resource scheduler.
     */
    public String getScheduler() {
        return this.Scheduler;
    }

    /**
     * Set Latest resource scheduler.
     * @param Scheduler Latest resource scheduler.
     */
    public void setScheduler(String Scheduler) {
        this.Scheduler = Scheduler;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeGlobalConfigResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeGlobalConfigResponse(DescribeGlobalConfigResponse source) {
        if (source.EnableResourceSchedule != null) {
            this.EnableResourceSchedule = new Boolean(source.EnableResourceSchedule);
        }
        if (source.ActiveScheduler != null) {
            this.ActiveScheduler = new String(source.ActiveScheduler);
        }
        if (source.CapacityGlobalConfig != null) {
            this.CapacityGlobalConfig = new CapacityGlobalConfig(source.CapacityGlobalConfig);
        }
        if (source.FairGlobalConfig != null) {
            this.FairGlobalConfig = new FairGlobalConfig(source.FairGlobalConfig);
        }
        if (source.Scheduler != null) {
            this.Scheduler = new String(source.Scheduler);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "EnableResourceSchedule", this.EnableResourceSchedule);
        this.setParamSimple(map, prefix + "ActiveScheduler", this.ActiveScheduler);
        this.setParamObj(map, prefix + "CapacityGlobalConfig.", this.CapacityGlobalConfig);
        this.setParamObj(map, prefix + "FairGlobalConfig.", this.FairGlobalConfig);
        this.setParamSimple(map, prefix + "Scheduler", this.Scheduler);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

