/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeHBaseTableOverviewResponse extends AbstractModel {

    /**
    * Overview data array
    */
    @SerializedName("TableMonitorList")
    @Expose
    private OverviewRow [] TableMonitorList;

    /**
    * Overview data array length
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Table schema information
    */
    @SerializedName("SchemaList")
    @Expose
    private TableSchemaItem [] SchemaList;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Overview data array 
     * @return TableMonitorList Overview data array
     */
    public OverviewRow [] getTableMonitorList() {
        return this.TableMonitorList;
    }

    /**
     * Set Overview data array
     * @param TableMonitorList Overview data array
     */
    public void setTableMonitorList(OverviewRow [] TableMonitorList) {
        this.TableMonitorList = TableMonitorList;
    }

    /**
     * Get Overview data array length 
     * @return TotalCount Overview data array length
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Overview data array length
     * @param TotalCount Overview data array length
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Table schema information 
     * @return SchemaList Table schema information
     */
    public TableSchemaItem [] getSchemaList() {
        return this.SchemaList;
    }

    /**
     * Set Table schema information
     * @param SchemaList Table schema information
     */
    public void setSchemaList(TableSchemaItem [] SchemaList) {
        this.SchemaList = SchemaList;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeHBaseTableOverviewResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeHBaseTableOverviewResponse(DescribeHBaseTableOverviewResponse source) {
        if (source.TableMonitorList != null) {
            this.TableMonitorList = new OverviewRow[source.TableMonitorList.length];
            for (int i = 0; i < source.TableMonitorList.length; i++) {
                this.TableMonitorList[i] = new OverviewRow(source.TableMonitorList[i]);
            }
        }
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.SchemaList != null) {
            this.SchemaList = new TableSchemaItem[source.SchemaList.length];
            for (int i = 0; i < source.SchemaList.length; i++) {
                this.SchemaList[i] = new TableSchemaItem(source.SchemaList[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "TableMonitorList.", this.TableMonitorList);
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArrayObj(map, prefix + "SchemaList.", this.SchemaList);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

