/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeHDFSStorageInfoResponse extends AbstractModel {

    /**
    * Sampling time.
    */
    @SerializedName("SampleTime")
    @Expose
    private Long SampleTime;

    /**
    * Hdfs storage details.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("StorageSummaryDistribution")
    @Expose
    private StorageSummaryDistribution [] StorageSummaryDistribution;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Sampling time. 
     * @return SampleTime Sampling time.
     */
    public Long getSampleTime() {
        return this.SampleTime;
    }

    /**
     * Set Sampling time.
     * @param SampleTime Sampling time.
     */
    public void setSampleTime(Long SampleTime) {
        this.SampleTime = SampleTime;
    }

    /**
     * Get Hdfs storage details.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return StorageSummaryDistribution Hdfs storage details.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public StorageSummaryDistribution [] getStorageSummaryDistribution() {
        return this.StorageSummaryDistribution;
    }

    /**
     * Set Hdfs storage details.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param StorageSummaryDistribution Hdfs storage details.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setStorageSummaryDistribution(StorageSummaryDistribution [] StorageSummaryDistribution) {
        this.StorageSummaryDistribution = StorageSummaryDistribution;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeHDFSStorageInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeHDFSStorageInfoResponse(DescribeHDFSStorageInfoResponse source) {
        if (source.SampleTime != null) {
            this.SampleTime = new Long(source.SampleTime);
        }
        if (source.StorageSummaryDistribution != null) {
            this.StorageSummaryDistribution = new StorageSummaryDistribution[source.StorageSummaryDistribution.length];
            for (int i = 0; i < source.StorageSummaryDistribution.length; i++) {
                this.StorageSummaryDistribution[i] = new StorageSummaryDistribution(source.StorageSummaryDistribution[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "SampleTime", this.SampleTime);
        this.setParamArrayObj(map, prefix + "StorageSummaryDistribution.", this.StorageSummaryDistribution);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

