/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeInspectionTaskResultResponse extends AbstractModel {

    /**
    * Inspection task record, encoded in Base64 format.
    */
    @SerializedName("InspectionResultInfo")
    @Expose
    private String InspectionResultInfo;

    /**
    * The total number of records.
    */
    @SerializedName("Total")
    @Expose
    private Long Total;

    /**
    * Category information encoded in Base64 format, which includes {"FixedTime": "Fixed time", "RealTime": "Real time"}.
    */
    @SerializedName("TypeInfo")
    @Expose
    private String TypeInfo;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Inspection task record, encoded in Base64 format. 
     * @return InspectionResultInfo Inspection task record, encoded in Base64 format.
     */
    public String getInspectionResultInfo() {
        return this.InspectionResultInfo;
    }

    /**
     * Set Inspection task record, encoded in Base64 format.
     * @param InspectionResultInfo Inspection task record, encoded in Base64 format.
     */
    public void setInspectionResultInfo(String InspectionResultInfo) {
        this.InspectionResultInfo = InspectionResultInfo;
    }

    /**
     * Get The total number of records. 
     * @return Total The total number of records.
     */
    public Long getTotal() {
        return this.Total;
    }

    /**
     * Set The total number of records.
     * @param Total The total number of records.
     */
    public void setTotal(Long Total) {
        this.Total = Total;
    }

    /**
     * Get Category information encoded in Base64 format, which includes {"FixedTime": "Fixed time", "RealTime": "Real time"}. 
     * @return TypeInfo Category information encoded in Base64 format, which includes {"FixedTime": "Fixed time", "RealTime": "Real time"}.
     */
    public String getTypeInfo() {
        return this.TypeInfo;
    }

    /**
     * Set Category information encoded in Base64 format, which includes {"FixedTime": "Fixed time", "RealTime": "Real time"}.
     * @param TypeInfo Category information encoded in Base64 format, which includes {"FixedTime": "Fixed time", "RealTime": "Real time"}.
     */
    public void setTypeInfo(String TypeInfo) {
        this.TypeInfo = TypeInfo;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeInspectionTaskResultResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeInspectionTaskResultResponse(DescribeInspectionTaskResultResponse source) {
        if (source.InspectionResultInfo != null) {
            this.InspectionResultInfo = new String(source.InspectionResultInfo);
        }
        if (source.Total != null) {
            this.Total = new Long(source.Total);
        }
        if (source.TypeInfo != null) {
            this.TypeInfo = new String(source.TypeInfo);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "InspectionResultInfo", this.InspectionResultInfo);
        this.setParamSimple(map, prefix + "Total", this.Total);
        this.setParamSimple(map, prefix + "TypeInfo", this.TypeInfo);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

