/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeKyuubiQueryInfoResponse extends AbstractModel {

    /**
    * Total number, which is used for pagination query.
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Kyuubi information list.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("KyuubiQueryInfoList")
    @Expose
    private KyuubiQueryInfo [] KyuubiQueryInfoList;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number, which is used for pagination query. 
     * @return TotalCount Total number, which is used for pagination query.
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number, which is used for pagination query.
     * @param TotalCount Total number, which is used for pagination query.
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Kyuubi information list.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return KyuubiQueryInfoList Kyuubi information list.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public KyuubiQueryInfo [] getKyuubiQueryInfoList() {
        return this.KyuubiQueryInfoList;
    }

    /**
     * Set Kyuubi information list.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param KyuubiQueryInfoList Kyuubi information list.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setKyuubiQueryInfoList(KyuubiQueryInfo [] KyuubiQueryInfoList) {
        this.KyuubiQueryInfoList = KyuubiQueryInfoList;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeKyuubiQueryInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeKyuubiQueryInfoResponse(DescribeKyuubiQueryInfoResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.KyuubiQueryInfoList != null) {
            this.KyuubiQueryInfoList = new KyuubiQueryInfo[source.KyuubiQueryInfoList.length];
            for (int i = 0; i < source.KyuubiQueryInfoList.length; i++) {
                this.KyuubiQueryInfoList[i] = new KyuubiQueryInfo(source.KyuubiQueryInfoList[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArrayObj(map, prefix + "KyuubiQueryInfoList.", this.KyuubiQueryInfoList);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

