/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeNodeDataDisksResponse extends AbstractModel {

    /**
    * Total number.
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Cloud disk list.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("CBSList")
    @Expose
    private CBSInstance [] CBSList;

    /**
    * Maximum cloud disk capacity.
    */
    @SerializedName("MaxSize")
    @Expose
    private Long MaxSize;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number. 
     * @return TotalCount Total number.
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number.
     * @param TotalCount Total number.
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Cloud disk list.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return CBSList Cloud disk list.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public CBSInstance [] getCBSList() {
        return this.CBSList;
    }

    /**
     * Set Cloud disk list.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param CBSList Cloud disk list.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setCBSList(CBSInstance [] CBSList) {
        this.CBSList = CBSList;
    }

    /**
     * Get Maximum cloud disk capacity. 
     * @return MaxSize Maximum cloud disk capacity.
     */
    public Long getMaxSize() {
        return this.MaxSize;
    }

    /**
     * Set Maximum cloud disk capacity.
     * @param MaxSize Maximum cloud disk capacity.
     */
    public void setMaxSize(Long MaxSize) {
        this.MaxSize = MaxSize;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeNodeDataDisksResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeNodeDataDisksResponse(DescribeNodeDataDisksResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.CBSList != null) {
            this.CBSList = new CBSInstance[source.CBSList.length];
            for (int i = 0; i < source.CBSList.length; i++) {
                this.CBSList[i] = new CBSInstance(source.CBSList[i]);
            }
        }
        if (source.MaxSize != null) {
            this.MaxSize = new Long(source.MaxSize);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArrayObj(map, prefix + "CBSList.", this.CBSList);
        this.setParamSimple(map, prefix + "MaxSize", this.MaxSize);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

