/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeSLInstanceResponse extends AbstractModel {

    /**
    * Character string identifier of the instance.
    */
    @SerializedName("InstanceId")
    @Expose
    private String InstanceId;

    /**
    * Instance name.
    */
    @SerializedName("InstanceName")
    @Expose
    private String InstanceName;

    /**
    * Instance billing mode. 0 indicates postpaid, i.e., pay-as-you-go; 1 indicates prepaid, i.e., monthly subscription.
    */
    @SerializedName("PayMode")
    @Expose
    private Long PayMode;

    /**
    * Instance storage type.
    */
    @SerializedName("DiskType")
    @Expose
    private String DiskType;

    /**
    * Instance single-node disk capacity, in GB.
    */
    @SerializedName("DiskSize")
    @Expose
    private Long DiskSize;

    /**
    * Instance node specifications.
    */
    @SerializedName("NodeType")
    @Expose
    private String NodeType;

    /**
    * Detailed configuration of the instance AZ, including the AZ name, VPC information, and number of nodes.
    */
    @SerializedName("ZoneSettings")
    @Expose
    private ZoneSetting [] ZoneSettings;

    /**
    * List of tags bound to the instance.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Tags")
    @Expose
    private Tag [] Tags;

    /**
    * Numeric identifier of the instance.
    */
    @SerializedName("ClusterId")
    @Expose
    private Long ClusterId;

    /**
    * Instance region ID.
    */
    @SerializedName("RegionId")
    @Expose
    private Long RegionId;

    /**
    * Primary AZ of the instance.
    */
    @SerializedName("Zone")
    @Expose
    private String Zone;

    /**
    * Instance expiration time. For post-paid instances, the API returns 0000-00-00 00:00:00.
    */
    @SerializedName("ExpireTime")
    @Expose
    private String ExpireTime;

    /**
    * Instance isolation time. For instances that are not isolated, the API returns 0000-00-00 00:00:00.
    */
    @SerializedName("IsolateTime")
    @Expose
    private String IsolateTime;

    /**
    * Instance creation time.
    */
    @SerializedName("CreateTime")
    @Expose
    private String CreateTime;

    /**
    * Instance status code: -2: "TERMINATED", 2: "RUNNING", 14: "TERMINATING", 19: "ISOLATING", 22: "ADJUSTING", and 201: "ISOLATED".
    */
    @SerializedName("Status")
    @Expose
    private Long Status;

    /**
    * Auto-renewal flag. 0: notify before expiration but do not auto-renew; 1: notify before expiration and auto-renew; and 2: do not notify before expiration and do not auto-renew. If the business does not support renewal, the value is 0.
    */
    @SerializedName("AutoRenewFlag")
    @Expose
    private Long AutoRenewFlag;

    /**
    * Total number of instance nodes.
    */
    @SerializedName("NodeNum")
    @Expose
    private Long NodeNum;

    /**
    * 
    */
    @SerializedName("SLInstance")
    @Expose
    private SLInstance [] SLInstance;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Character string identifier of the instance. 
     * @return InstanceId Character string identifier of the instance.
     */
    public String getInstanceId() {
        return this.InstanceId;
    }

    /**
     * Set Character string identifier of the instance.
     * @param InstanceId Character string identifier of the instance.
     */
    public void setInstanceId(String InstanceId) {
        this.InstanceId = InstanceId;
    }

    /**
     * Get Instance name. 
     * @return InstanceName Instance name.
     */
    public String getInstanceName() {
        return this.InstanceName;
    }

    /**
     * Set Instance name.
     * @param InstanceName Instance name.
     */
    public void setInstanceName(String InstanceName) {
        this.InstanceName = InstanceName;
    }

    /**
     * Get Instance billing mode. 0 indicates postpaid, i.e., pay-as-you-go; 1 indicates prepaid, i.e., monthly subscription. 
     * @return PayMode Instance billing mode. 0 indicates postpaid, i.e., pay-as-you-go; 1 indicates prepaid, i.e., monthly subscription.
     */
    public Long getPayMode() {
        return this.PayMode;
    }

    /**
     * Set Instance billing mode. 0 indicates postpaid, i.e., pay-as-you-go; 1 indicates prepaid, i.e., monthly subscription.
     * @param PayMode Instance billing mode. 0 indicates postpaid, i.e., pay-as-you-go; 1 indicates prepaid, i.e., monthly subscription.
     */
    public void setPayMode(Long PayMode) {
        this.PayMode = PayMode;
    }

    /**
     * Get Instance storage type. 
     * @return DiskType Instance storage type.
     */
    public String getDiskType() {
        return this.DiskType;
    }

    /**
     * Set Instance storage type.
     * @param DiskType Instance storage type.
     */
    public void setDiskType(String DiskType) {
        this.DiskType = DiskType;
    }

    /**
     * Get Instance single-node disk capacity, in GB. 
     * @return DiskSize Instance single-node disk capacity, in GB.
     */
    public Long getDiskSize() {
        return this.DiskSize;
    }

    /**
     * Set Instance single-node disk capacity, in GB.
     * @param DiskSize Instance single-node disk capacity, in GB.
     */
    public void setDiskSize(Long DiskSize) {
        this.DiskSize = DiskSize;
    }

    /**
     * Get Instance node specifications. 
     * @return NodeType Instance node specifications.
     */
    public String getNodeType() {
        return this.NodeType;
    }

    /**
     * Set Instance node specifications.
     * @param NodeType Instance node specifications.
     */
    public void setNodeType(String NodeType) {
        this.NodeType = NodeType;
    }

    /**
     * Get Detailed configuration of the instance AZ, including the AZ name, VPC information, and number of nodes. 
     * @return ZoneSettings Detailed configuration of the instance AZ, including the AZ name, VPC information, and number of nodes.
     */
    public ZoneSetting [] getZoneSettings() {
        return this.ZoneSettings;
    }

    /**
     * Set Detailed configuration of the instance AZ, including the AZ name, VPC information, and number of nodes.
     * @param ZoneSettings Detailed configuration of the instance AZ, including the AZ name, VPC information, and number of nodes.
     */
    public void setZoneSettings(ZoneSetting [] ZoneSettings) {
        this.ZoneSettings = ZoneSettings;
    }

    /**
     * Get List of tags bound to the instance.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Tags List of tags bound to the instance.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Tag [] getTags() {
        return this.Tags;
    }

    /**
     * Set List of tags bound to the instance.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Tags List of tags bound to the instance.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setTags(Tag [] Tags) {
        this.Tags = Tags;
    }

    /**
     * Get Numeric identifier of the instance. 
     * @return ClusterId Numeric identifier of the instance.
     */
    public Long getClusterId() {
        return this.ClusterId;
    }

    /**
     * Set Numeric identifier of the instance.
     * @param ClusterId Numeric identifier of the instance.
     */
    public void setClusterId(Long ClusterId) {
        this.ClusterId = ClusterId;
    }

    /**
     * Get Instance region ID. 
     * @return RegionId Instance region ID.
     */
    public Long getRegionId() {
        return this.RegionId;
    }

    /**
     * Set Instance region ID.
     * @param RegionId Instance region ID.
     */
    public void setRegionId(Long RegionId) {
        this.RegionId = RegionId;
    }

    /**
     * Get Primary AZ of the instance. 
     * @return Zone Primary AZ of the instance.
     */
    public String getZone() {
        return this.Zone;
    }

    /**
     * Set Primary AZ of the instance.
     * @param Zone Primary AZ of the instance.
     */
    public void setZone(String Zone) {
        this.Zone = Zone;
    }

    /**
     * Get Instance expiration time. For post-paid instances, the API returns 0000-00-00 00:00:00. 
     * @return ExpireTime Instance expiration time. For post-paid instances, the API returns 0000-00-00 00:00:00.
     */
    public String getExpireTime() {
        return this.ExpireTime;
    }

    /**
     * Set Instance expiration time. For post-paid instances, the API returns 0000-00-00 00:00:00.
     * @param ExpireTime Instance expiration time. For post-paid instances, the API returns 0000-00-00 00:00:00.
     */
    public void setExpireTime(String ExpireTime) {
        this.ExpireTime = ExpireTime;
    }

    /**
     * Get Instance isolation time. For instances that are not isolated, the API returns 0000-00-00 00:00:00. 
     * @return IsolateTime Instance isolation time. For instances that are not isolated, the API returns 0000-00-00 00:00:00.
     */
    public String getIsolateTime() {
        return this.IsolateTime;
    }

    /**
     * Set Instance isolation time. For instances that are not isolated, the API returns 0000-00-00 00:00:00.
     * @param IsolateTime Instance isolation time. For instances that are not isolated, the API returns 0000-00-00 00:00:00.
     */
    public void setIsolateTime(String IsolateTime) {
        this.IsolateTime = IsolateTime;
    }

    /**
     * Get Instance creation time. 
     * @return CreateTime Instance creation time.
     */
    public String getCreateTime() {
        return this.CreateTime;
    }

    /**
     * Set Instance creation time.
     * @param CreateTime Instance creation time.
     */
    public void setCreateTime(String CreateTime) {
        this.CreateTime = CreateTime;
    }

    /**
     * Get Instance status code: -2: "TERMINATED", 2: "RUNNING", 14: "TERMINATING", 19: "ISOLATING", 22: "ADJUSTING", and 201: "ISOLATED". 
     * @return Status Instance status code: -2: "TERMINATED", 2: "RUNNING", 14: "TERMINATING", 19: "ISOLATING", 22: "ADJUSTING", and 201: "ISOLATED".
     */
    public Long getStatus() {
        return this.Status;
    }

    /**
     * Set Instance status code: -2: "TERMINATED", 2: "RUNNING", 14: "TERMINATING", 19: "ISOLATING", 22: "ADJUSTING", and 201: "ISOLATED".
     * @param Status Instance status code: -2: "TERMINATED", 2: "RUNNING", 14: "TERMINATING", 19: "ISOLATING", 22: "ADJUSTING", and 201: "ISOLATED".
     */
    public void setStatus(Long Status) {
        this.Status = Status;
    }

    /**
     * Get Auto-renewal flag. 0: notify before expiration but do not auto-renew; 1: notify before expiration and auto-renew; and 2: do not notify before expiration and do not auto-renew. If the business does not support renewal, the value is 0. 
     * @return AutoRenewFlag Auto-renewal flag. 0: notify before expiration but do not auto-renew; 1: notify before expiration and auto-renew; and 2: do not notify before expiration and do not auto-renew. If the business does not support renewal, the value is 0.
     */
    public Long getAutoRenewFlag() {
        return this.AutoRenewFlag;
    }

    /**
     * Set Auto-renewal flag. 0: notify before expiration but do not auto-renew; 1: notify before expiration and auto-renew; and 2: do not notify before expiration and do not auto-renew. If the business does not support renewal, the value is 0.
     * @param AutoRenewFlag Auto-renewal flag. 0: notify before expiration but do not auto-renew; 1: notify before expiration and auto-renew; and 2: do not notify before expiration and do not auto-renew. If the business does not support renewal, the value is 0.
     */
    public void setAutoRenewFlag(Long AutoRenewFlag) {
        this.AutoRenewFlag = AutoRenewFlag;
    }

    /**
     * Get Total number of instance nodes. 
     * @return NodeNum Total number of instance nodes.
     */
    public Long getNodeNum() {
        return this.NodeNum;
    }

    /**
     * Set Total number of instance nodes.
     * @param NodeNum Total number of instance nodes.
     */
    public void setNodeNum(Long NodeNum) {
        this.NodeNum = NodeNum;
    }

    /**
     * Get  
     * @return SLInstance 
     */
    public SLInstance [] getSLInstance() {
        return this.SLInstance;
    }

    /**
     * Set 
     * @param SLInstance 
     */
    public void setSLInstance(SLInstance [] SLInstance) {
        this.SLInstance = SLInstance;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeSLInstanceResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeSLInstanceResponse(DescribeSLInstanceResponse source) {
        if (source.InstanceId != null) {
            this.InstanceId = new String(source.InstanceId);
        }
        if (source.InstanceName != null) {
            this.InstanceName = new String(source.InstanceName);
        }
        if (source.PayMode != null) {
            this.PayMode = new Long(source.PayMode);
        }
        if (source.DiskType != null) {
            this.DiskType = new String(source.DiskType);
        }
        if (source.DiskSize != null) {
            this.DiskSize = new Long(source.DiskSize);
        }
        if (source.NodeType != null) {
            this.NodeType = new String(source.NodeType);
        }
        if (source.ZoneSettings != null) {
            this.ZoneSettings = new ZoneSetting[source.ZoneSettings.length];
            for (int i = 0; i < source.ZoneSettings.length; i++) {
                this.ZoneSettings[i] = new ZoneSetting(source.ZoneSettings[i]);
            }
        }
        if (source.Tags != null) {
            this.Tags = new Tag[source.Tags.length];
            for (int i = 0; i < source.Tags.length; i++) {
                this.Tags[i] = new Tag(source.Tags[i]);
            }
        }
        if (source.ClusterId != null) {
            this.ClusterId = new Long(source.ClusterId);
        }
        if (source.RegionId != null) {
            this.RegionId = new Long(source.RegionId);
        }
        if (source.Zone != null) {
            this.Zone = new String(source.Zone);
        }
        if (source.ExpireTime != null) {
            this.ExpireTime = new String(source.ExpireTime);
        }
        if (source.IsolateTime != null) {
            this.IsolateTime = new String(source.IsolateTime);
        }
        if (source.CreateTime != null) {
            this.CreateTime = new String(source.CreateTime);
        }
        if (source.Status != null) {
            this.Status = new Long(source.Status);
        }
        if (source.AutoRenewFlag != null) {
            this.AutoRenewFlag = new Long(source.AutoRenewFlag);
        }
        if (source.NodeNum != null) {
            this.NodeNum = new Long(source.NodeNum);
        }
        if (source.SLInstance != null) {
            this.SLInstance = new SLInstance[source.SLInstance.length];
            for (int i = 0; i < source.SLInstance.length; i++) {
                this.SLInstance[i] = new SLInstance(source.SLInstance[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "InstanceId", this.InstanceId);
        this.setParamSimple(map, prefix + "InstanceName", this.InstanceName);
        this.setParamSimple(map, prefix + "PayMode", this.PayMode);
        this.setParamSimple(map, prefix + "DiskType", this.DiskType);
        this.setParamSimple(map, prefix + "DiskSize", this.DiskSize);
        this.setParamSimple(map, prefix + "NodeType", this.NodeType);
        this.setParamArrayObj(map, prefix + "ZoneSettings.", this.ZoneSettings);
        this.setParamArrayObj(map, prefix + "Tags.", this.Tags);
        this.setParamSimple(map, prefix + "ClusterId", this.ClusterId);
        this.setParamSimple(map, prefix + "RegionId", this.RegionId);
        this.setParamSimple(map, prefix + "Zone", this.Zone);
        this.setParamSimple(map, prefix + "ExpireTime", this.ExpireTime);
        this.setParamSimple(map, prefix + "IsolateTime", this.IsolateTime);
        this.setParamSimple(map, prefix + "CreateTime", this.CreateTime);
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "AutoRenewFlag", this.AutoRenewFlag);
        this.setParamSimple(map, prefix + "NodeNum", this.NodeNum);
        this.setParamArrayObj(map, prefix + "SLInstance.", this.SLInstance);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

