/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeServiceNodeInfosResponse extends AbstractModel {

    /**
    * Total number.
    */
    @SerializedName("TotalCnt")
    @Expose
    private Long TotalCnt;

    /**
    * Process information.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ServiceNodeList")
    @Expose
    private ServiceNodeDetailInfo [] ServiceNodeList;

    /**
    * Alias serialization of all nodes in the cluster.
    */
    @SerializedName("AliasInfo")
    @Expose
    private String AliasInfo;

    /**
    * Supported FlagNode list

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("SupportNodeFlagFilterList")
    @Expose
    private String [] SupportNodeFlagFilterList;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number. 
     * @return TotalCnt Total number.
     */
    public Long getTotalCnt() {
        return this.TotalCnt;
    }

    /**
     * Set Total number.
     * @param TotalCnt Total number.
     */
    public void setTotalCnt(Long TotalCnt) {
        this.TotalCnt = TotalCnt;
    }

    /**
     * Get Process information.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ServiceNodeList Process information.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public ServiceNodeDetailInfo [] getServiceNodeList() {
        return this.ServiceNodeList;
    }

    /**
     * Set Process information.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param ServiceNodeList Process information.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setServiceNodeList(ServiceNodeDetailInfo [] ServiceNodeList) {
        this.ServiceNodeList = ServiceNodeList;
    }

    /**
     * Get Alias serialization of all nodes in the cluster. 
     * @return AliasInfo Alias serialization of all nodes in the cluster.
     */
    public String getAliasInfo() {
        return this.AliasInfo;
    }

    /**
     * Set Alias serialization of all nodes in the cluster.
     * @param AliasInfo Alias serialization of all nodes in the cluster.
     */
    public void setAliasInfo(String AliasInfo) {
        this.AliasInfo = AliasInfo;
    }

    /**
     * Get Supported FlagNode list

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return SupportNodeFlagFilterList Supported FlagNode list

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getSupportNodeFlagFilterList() {
        return this.SupportNodeFlagFilterList;
    }

    /**
     * Set Supported FlagNode list

Note: This field may return null, indicating that no valid values can be obtained.
     * @param SupportNodeFlagFilterList Supported FlagNode list

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setSupportNodeFlagFilterList(String [] SupportNodeFlagFilterList) {
        this.SupportNodeFlagFilterList = SupportNodeFlagFilterList;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeServiceNodeInfosResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeServiceNodeInfosResponse(DescribeServiceNodeInfosResponse source) {
        if (source.TotalCnt != null) {
            this.TotalCnt = new Long(source.TotalCnt);
        }
        if (source.ServiceNodeList != null) {
            this.ServiceNodeList = new ServiceNodeDetailInfo[source.ServiceNodeList.length];
            for (int i = 0; i < source.ServiceNodeList.length; i++) {
                this.ServiceNodeList[i] = new ServiceNodeDetailInfo(source.ServiceNodeList[i]);
            }
        }
        if (source.AliasInfo != null) {
            this.AliasInfo = new String(source.AliasInfo);
        }
        if (source.SupportNodeFlagFilterList != null) {
            this.SupportNodeFlagFilterList = new String[source.SupportNodeFlagFilterList.length];
            for (int i = 0; i < source.SupportNodeFlagFilterList.length; i++) {
                this.SupportNodeFlagFilterList[i] = new String(source.SupportNodeFlagFilterList[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCnt", this.TotalCnt);
        this.setParamArrayObj(map, prefix + "ServiceNodeList.", this.ServiceNodeList);
        this.setParamSimple(map, prefix + "AliasInfo", this.AliasInfo);
        this.setParamArraySimple(map, prefix + "SupportNodeFlagFilterList.", this.SupportNodeFlagFilterList);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

