/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeYarnQueueResponse extends AbstractModel {

    /**
    * Queue information. It is a JSON string into which an object is converted. The corresponding Golang structure is as follows. For example, the first field `Name` of `QueueWithConfigSetForFairScheduler: ```Name                         string                               `json:"name"` //queue name ```  - `Name: field name - `string`: field type - `json:"name`:  indicates the corresponding `json key` during serialization/deserialization. Below, `json key` is used for referring.- `//`: the following comment content corresponds to the Name field seen on the page. Fields with types starting with `*` indicate that the value may be null under JSON specifications. Different languages need to be received through a type that can express null, such as Java's wrapper types. Fields with types starting with `[]` indicate an array type, which is used when `json key` calls `ModifyYarnQueueV2` API. - fair scheduler```type QueueWithConfigSetForFairScheduler struct {	Name                         string                               `json:"name"` //queue name MyId                         string                  `json:"myId"` // queue id, used for editing, deleting, and cloning	ParentId                     string                  `json:"parentId"`  // Parent queue Id	Type                         *string                              `json:"type"` // queue affinity. Parent or empty. Setting to be a parent or empty can be performed only when it is confirmed that a queue is a parent queue and has no subqueues. The queue is normally used to support the placement policy nestedUserQueue	AclSubmitApps                *AclForYarnQueue                     `json:"aclSubmitApps"` // submission access control	AclAdministerApps            *AclForYarnQueue                     `json:"aclAdministerApps"` // management access control	MinSharePreemptionTimeout    *int                                 `json:"minSharePreemptionTimeout"` // minimum share preemption timeout period	FairSharePreemptionTimeout   *int                                 `json:"fairSharePreemptionTimeout"` // fair share preemption timeout period	FairSharePreemptionThreshold *float32                             `json:"fairSharePreemptionThreshold"` // fair share preemption threshold. Value range (0, 1]	AllowPreemptionFrom          *bool                                `json:"allowPreemptionFrom"`                                        // preemption mode	SchedulingPolicy             *string                              `json:"schedulingPolicy"`  // scheduling policy with the valid values of drf, fair, and fifo	IsDefault                    *bool                                `json:"isDefault"` // whether it is the root.default queue	IsRoot                       *bool                                `json:"isRoot"` // whether it is the root queue	ConfigSets                   []ConfigSetForFairScheduler          `json:"configSets"` // configuration set settings	Children                     []QueueWithConfigSetForFairScheduler `json:"queues"` // subqueue information. recursive}type AclForYarnQueue struct {	User  *string `json:"user"` //username	Group *string `json:"group"`//group name}type ConfigSetForFairScheduler struct {	Name              string        `json:"name"` // configuration set name	MinResources      *YarnResource `json:"minResources"` // minimum resource amount	MaxResources      *YarnResource `json:"maxResources"` // maximum resource amount	MaxChildResources *YarnResource `json:"maxChildResources"` //.The maximum quantity of resources that can be allocated to undefined subqueues	MaxRunningApps    *int          `json:"maxRunningApps"` // the maximum number of apps that can run concurrently	Weight            *float32      `json:"weight"`                   // Weight	MaxAMShare        *float32      `json:"maxAMShare"` // App Master maximum share}type YarnResource struct {	Vcores *int `json:"vcores"`	Memory *int `json:"memory"`	Type *string `json:"type"` // when the value is `percent`, it indicates usage as a percentage, otherwise an absolute value is used indeed}```- Capacity scheduler```type QueueForCapacitySchedulerV3 struct {	Name                       string                `json:"name"` // queue name	MyId                       string                `json:"myId"` // queue id, used in the case of editing, deleting, or cloning	ParentId                   string                `json:"parentId"` // parent queue id 	Configs                    []ConfigForCapacityV3 `json:"configs"` //configuration set settings	State                      *string         `json:"state"` // resource pool status	DefaultNodeLabelExpression *string               `json:"default-node-label-expression"` // default tag expression	AclSubmitApps              *AclForYarnQueue      `json:"acl_submit_applications"` // submission access control 	AclAdminQueue              *AclForYarnQueue      `json:"acl_administer_queue"` //management access control	MaxAllocationMB *int32 `json:"maximum-allocation-mb"` // maximum Memory allocated to Container	MaxAllocationVcores *int32                         `json:"maximum-allocation-vcores"` // the maximum number of Vcores for Container	IsDefault           *bool                          `json:"isDefault"`// whether it is the root.default queue	IsRoot              *bool                          `json:"isRoot"` // whether it is the root queue	Queues              []*QueueForCapacitySchedulerV3 `json:"queues"`//subqueue information. Recursive}type ConfigForCapacityV3 struct {	Name                string          `json:"configName"` // configuration set name	Labels              []CapacityLabel `json:"labels"` // tag information	MinUserLimitPercent *int32          `json:"minimum-user-limit-percent"` // minimum user capacity	UserLimitFactor     *float32        `json:"user-limit-factor" valid:"rangeExcludeLeft(0|)"`  // user resource factor	MaxApps *int32 `json:"maximum-applications" valid:"rangeExcludeLeft(0|)"` // the maximum number of applications Max-Applications	MaxAmPercent               *float32 `json:"maximum-am-resource-percent"` // the maximum AM ratio	DefaultApplicationPriority *int32   `json:"default-application-priority"` // resource pool priority}type CapacityLabel struct {	Name        string   `json:"labelName"`	Capacity    *float32 `json:"capacity"`  // capacity MaxCapacity *float32 `json:"maximum-capacity"` //maximum capacity}type AclForYarnQueue struct {	User  *string `json:"user"` //username	Group *string `json:"group"`//group name}```.
    */
    @SerializedName("Queue")
    @Expose
    private String Queue;

    /**
    * Version
    */
    @SerializedName("Version")
    @Expose
    private String Version;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Queue information. It is a JSON string into which an object is converted. The corresponding Golang structure is as follows. For example, the first field `Name` of `QueueWithConfigSetForFairScheduler: ```Name                         string                               `json:"name"` //queue name ```  - `Name: field name - `string`: field type - `json:"name`:  indicates the corresponding `json key` during serialization/deserialization. Below, `json key` is used for referring.- `//`: the following comment content corresponds to the Name field seen on the page. Fields with types starting with `*` indicate that the value may be null under JSON specifications. Different languages need to be received through a type that can express null, such as Java's wrapper types. Fields with types starting with `[]` indicate an array type, which is used when `json key` calls `ModifyYarnQueueV2` API. - fair scheduler```type QueueWithConfigSetForFairScheduler struct {	Name                         string                               `json:"name"` //queue name MyId                         string                  `json:"myId"` // queue id, used for editing, deleting, and cloning	ParentId                     string                  `json:"parentId"`  // Parent queue Id	Type                         *string                              `json:"type"` // queue affinity. Parent or empty. Setting to be a parent or empty can be performed only when it is confirmed that a queue is a parent queue and has no subqueues. The queue is normally used to support the placement policy nestedUserQueue	AclSubmitApps                *AclForYarnQueue                     `json:"aclSubmitApps"` // submission access control	AclAdministerApps            *AclForYarnQueue                     `json:"aclAdministerApps"` // management access control	MinSharePreemptionTimeout    *int                                 `json:"minSharePreemptionTimeout"` // minimum share preemption timeout period	FairSharePreemptionTimeout   *int                                 `json:"fairSharePreemptionTimeout"` // fair share preemption timeout period	FairSharePreemptionThreshold *float32                             `json:"fairSharePreemptionThreshold"` // fair share preemption threshold. Value range (0, 1]	AllowPreemptionFrom          *bool                                `json:"allowPreemptionFrom"`                                        // preemption mode	SchedulingPolicy             *string                              `json:"schedulingPolicy"`  // scheduling policy with the valid values of drf, fair, and fifo	IsDefault                    *bool                                `json:"isDefault"` // whether it is the root.default queue	IsRoot                       *bool                                `json:"isRoot"` // whether it is the root queue	ConfigSets                   []ConfigSetForFairScheduler          `json:"configSets"` // configuration set settings	Children                     []QueueWithConfigSetForFairScheduler `json:"queues"` // subqueue information. recursive}type AclForYarnQueue struct {	User  *string `json:"user"` //username	Group *string `json:"group"`//group name}type ConfigSetForFairScheduler struct {	Name              string        `json:"name"` // configuration set name	MinResources      *YarnResource `json:"minResources"` // minimum resource amount	MaxResources      *YarnResource `json:"maxResources"` // maximum resource amount	MaxChildResources *YarnResource `json:"maxChildResources"` //.The maximum quantity of resources that can be allocated to undefined subqueues	MaxRunningApps    *int          `json:"maxRunningApps"` // the maximum number of apps that can run concurrently	Weight            *float32      `json:"weight"`                   // Weight	MaxAMShare        *float32      `json:"maxAMShare"` // App Master maximum share}type YarnResource struct {	Vcores *int `json:"vcores"`	Memory *int `json:"memory"`	Type *string `json:"type"` // when the value is `percent`, it indicates usage as a percentage, otherwise an absolute value is used indeed}```- Capacity scheduler```type QueueForCapacitySchedulerV3 struct {	Name                       string                `json:"name"` // queue name	MyId                       string                `json:"myId"` // queue id, used in the case of editing, deleting, or cloning	ParentId                   string                `json:"parentId"` // parent queue id 	Configs                    []ConfigForCapacityV3 `json:"configs"` //configuration set settings	State                      *string         `json:"state"` // resource pool status	DefaultNodeLabelExpression *string               `json:"default-node-label-expression"` // default tag expression	AclSubmitApps              *AclForYarnQueue      `json:"acl_submit_applications"` // submission access control 	AclAdminQueue              *AclForYarnQueue      `json:"acl_administer_queue"` //management access control	MaxAllocationMB *int32 `json:"maximum-allocation-mb"` // maximum Memory allocated to Container	MaxAllocationVcores *int32                         `json:"maximum-allocation-vcores"` // the maximum number of Vcores for Container	IsDefault           *bool                          `json:"isDefault"`// whether it is the root.default queue	IsRoot              *bool                          `json:"isRoot"` // whether it is the root queue	Queues              []*QueueForCapacitySchedulerV3 `json:"queues"`//subqueue information. Recursive}type ConfigForCapacityV3 struct {	Name                string          `json:"configName"` // configuration set name	Labels              []CapacityLabel `json:"labels"` // tag information	MinUserLimitPercent *int32          `json:"minimum-user-limit-percent"` // minimum user capacity	UserLimitFactor     *float32        `json:"user-limit-factor" valid:"rangeExcludeLeft(0|)"`  // user resource factor	MaxApps *int32 `json:"maximum-applications" valid:"rangeExcludeLeft(0|)"` // the maximum number of applications Max-Applications	MaxAmPercent               *float32 `json:"maximum-am-resource-percent"` // the maximum AM ratio	DefaultApplicationPriority *int32   `json:"default-application-priority"` // resource pool priority}type CapacityLabel struct {	Name        string   `json:"labelName"`	Capacity    *float32 `json:"capacity"`  // capacity MaxCapacity *float32 `json:"maximum-capacity"` //maximum capacity}type AclForYarnQueue struct {	User  *string `json:"user"` //username	Group *string `json:"group"`//group name}```. 
     * @return Queue Queue information. It is a JSON string into which an object is converted. The corresponding Golang structure is as follows. For example, the first field `Name` of `QueueWithConfigSetForFairScheduler: ```Name                         string                               `json:"name"` //queue name ```  - `Name: field name - `string`: field type - `json:"name`:  indicates the corresponding `json key` during serialization/deserialization. Below, `json key` is used for referring.- `//`: the following comment content corresponds to the Name field seen on the page. Fields with types starting with `*` indicate that the value may be null under JSON specifications. Different languages need to be received through a type that can express null, such as Java's wrapper types. Fields with types starting with `[]` indicate an array type, which is used when `json key` calls `ModifyYarnQueueV2` API. - fair scheduler```type QueueWithConfigSetForFairScheduler struct {	Name                         string                               `json:"name"` //queue name MyId                         string                  `json:"myId"` // queue id, used for editing, deleting, and cloning	ParentId                     string                  `json:"parentId"`  // Parent queue Id	Type                         *string                              `json:"type"` // queue affinity. Parent or empty. Setting to be a parent or empty can be performed only when it is confirmed that a queue is a parent queue and has no subqueues. The queue is normally used to support the placement policy nestedUserQueue	AclSubmitApps                *AclForYarnQueue                     `json:"aclSubmitApps"` // submission access control	AclAdministerApps            *AclForYarnQueue                     `json:"aclAdministerApps"` // management access control	MinSharePreemptionTimeout    *int                                 `json:"minSharePreemptionTimeout"` // minimum share preemption timeout period	FairSharePreemptionTimeout   *int                                 `json:"fairSharePreemptionTimeout"` // fair share preemption timeout period	FairSharePreemptionThreshold *float32                             `json:"fairSharePreemptionThreshold"` // fair share preemption threshold. Value range (0, 1]	AllowPreemptionFrom          *bool                                `json:"allowPreemptionFrom"`                                        // preemption mode	SchedulingPolicy             *string                              `json:"schedulingPolicy"`  // scheduling policy with the valid values of drf, fair, and fifo	IsDefault                    *bool                                `json:"isDefault"` // whether it is the root.default queue	IsRoot                       *bool                                `json:"isRoot"` // whether it is the root queue	ConfigSets                   []ConfigSetForFairScheduler          `json:"configSets"` // configuration set settings	Children                     []QueueWithConfigSetForFairScheduler `json:"queues"` // subqueue information. recursive}type AclForYarnQueue struct {	User  *string `json:"user"` //username	Group *string `json:"group"`//group name}type ConfigSetForFairScheduler struct {	Name              string        `json:"name"` // configuration set name	MinResources      *YarnResource `json:"minResources"` // minimum resource amount	MaxResources      *YarnResource `json:"maxResources"` // maximum resource amount	MaxChildResources *YarnResource `json:"maxChildResources"` //.The maximum quantity of resources that can be allocated to undefined subqueues	MaxRunningApps    *int          `json:"maxRunningApps"` // the maximum number of apps that can run concurrently	Weight            *float32      `json:"weight"`                   // Weight	MaxAMShare        *float32      `json:"maxAMShare"` // App Master maximum share}type YarnResource struct {	Vcores *int `json:"vcores"`	Memory *int `json:"memory"`	Type *string `json:"type"` // when the value is `percent`, it indicates usage as a percentage, otherwise an absolute value is used indeed}```- Capacity scheduler```type QueueForCapacitySchedulerV3 struct {	Name                       string                `json:"name"` // queue name	MyId                       string                `json:"myId"` // queue id, used in the case of editing, deleting, or cloning	ParentId                   string                `json:"parentId"` // parent queue id 	Configs                    []ConfigForCapacityV3 `json:"configs"` //configuration set settings	State                      *string         `json:"state"` // resource pool status	DefaultNodeLabelExpression *string               `json:"default-node-label-expression"` // default tag expression	AclSubmitApps              *AclForYarnQueue      `json:"acl_submit_applications"` // submission access control 	AclAdminQueue              *AclForYarnQueue      `json:"acl_administer_queue"` //management access control	MaxAllocationMB *int32 `json:"maximum-allocation-mb"` // maximum Memory allocated to Container	MaxAllocationVcores *int32                         `json:"maximum-allocation-vcores"` // the maximum number of Vcores for Container	IsDefault           *bool                          `json:"isDefault"`// whether it is the root.default queue	IsRoot              *bool                          `json:"isRoot"` // whether it is the root queue	Queues              []*QueueForCapacitySchedulerV3 `json:"queues"`//subqueue information. Recursive}type ConfigForCapacityV3 struct {	Name                string          `json:"configName"` // configuration set name	Labels              []CapacityLabel `json:"labels"` // tag information	MinUserLimitPercent *int32          `json:"minimum-user-limit-percent"` // minimum user capacity	UserLimitFactor     *float32        `json:"user-limit-factor" valid:"rangeExcludeLeft(0|)"`  // user resource factor	MaxApps *int32 `json:"maximum-applications" valid:"rangeExcludeLeft(0|)"` // the maximum number of applications Max-Applications	MaxAmPercent               *float32 `json:"maximum-am-resource-percent"` // the maximum AM ratio	DefaultApplicationPriority *int32   `json:"default-application-priority"` // resource pool priority}type CapacityLabel struct {	Name        string   `json:"labelName"`	Capacity    *float32 `json:"capacity"`  // capacity MaxCapacity *float32 `json:"maximum-capacity"` //maximum capacity}type AclForYarnQueue struct {	User  *string `json:"user"` //username	Group *string `json:"group"`//group name}```.
     */
    public String getQueue() {
        return this.Queue;
    }

    /**
     * Set Queue information. It is a JSON string into which an object is converted. The corresponding Golang structure is as follows. For example, the first field `Name` of `QueueWithConfigSetForFairScheduler: ```Name                         string                               `json:"name"` //queue name ```  - `Name: field name - `string`: field type - `json:"name`:  indicates the corresponding `json key` during serialization/deserialization. Below, `json key` is used for referring.- `//`: the following comment content corresponds to the Name field seen on the page. Fields with types starting with `*` indicate that the value may be null under JSON specifications. Different languages need to be received through a type that can express null, such as Java's wrapper types. Fields with types starting with `[]` indicate an array type, which is used when `json key` calls `ModifyYarnQueueV2` API. - fair scheduler```type QueueWithConfigSetForFairScheduler struct {	Name                         string                               `json:"name"` //queue name MyId                         string                  `json:"myId"` // queue id, used for editing, deleting, and cloning	ParentId                     string                  `json:"parentId"`  // Parent queue Id	Type                         *string                              `json:"type"` // queue affinity. Parent or empty. Setting to be a parent or empty can be performed only when it is confirmed that a queue is a parent queue and has no subqueues. The queue is normally used to support the placement policy nestedUserQueue	AclSubmitApps                *AclForYarnQueue                     `json:"aclSubmitApps"` // submission access control	AclAdministerApps            *AclForYarnQueue                     `json:"aclAdministerApps"` // management access control	MinSharePreemptionTimeout    *int                                 `json:"minSharePreemptionTimeout"` // minimum share preemption timeout period	FairSharePreemptionTimeout   *int                                 `json:"fairSharePreemptionTimeout"` // fair share preemption timeout period	FairSharePreemptionThreshold *float32                             `json:"fairSharePreemptionThreshold"` // fair share preemption threshold. Value range (0, 1]	AllowPreemptionFrom          *bool                                `json:"allowPreemptionFrom"`                                        // preemption mode	SchedulingPolicy             *string                              `json:"schedulingPolicy"`  // scheduling policy with the valid values of drf, fair, and fifo	IsDefault                    *bool                                `json:"isDefault"` // whether it is the root.default queue	IsRoot                       *bool                                `json:"isRoot"` // whether it is the root queue	ConfigSets                   []ConfigSetForFairScheduler          `json:"configSets"` // configuration set settings	Children                     []QueueWithConfigSetForFairScheduler `json:"queues"` // subqueue information. recursive}type AclForYarnQueue struct {	User  *string `json:"user"` //username	Group *string `json:"group"`//group name}type ConfigSetForFairScheduler struct {	Name              string        `json:"name"` // configuration set name	MinResources      *YarnResource `json:"minResources"` // minimum resource amount	MaxResources      *YarnResource `json:"maxResources"` // maximum resource amount	MaxChildResources *YarnResource `json:"maxChildResources"` //.The maximum quantity of resources that can be allocated to undefined subqueues	MaxRunningApps    *int          `json:"maxRunningApps"` // the maximum number of apps that can run concurrently	Weight            *float32      `json:"weight"`                   // Weight	MaxAMShare        *float32      `json:"maxAMShare"` // App Master maximum share}type YarnResource struct {	Vcores *int `json:"vcores"`	Memory *int `json:"memory"`	Type *string `json:"type"` // when the value is `percent`, it indicates usage as a percentage, otherwise an absolute value is used indeed}```- Capacity scheduler```type QueueForCapacitySchedulerV3 struct {	Name                       string                `json:"name"` // queue name	MyId                       string                `json:"myId"` // queue id, used in the case of editing, deleting, or cloning	ParentId                   string                `json:"parentId"` // parent queue id 	Configs                    []ConfigForCapacityV3 `json:"configs"` //configuration set settings	State                      *string         `json:"state"` // resource pool status	DefaultNodeLabelExpression *string               `json:"default-node-label-expression"` // default tag expression	AclSubmitApps              *AclForYarnQueue      `json:"acl_submit_applications"` // submission access control 	AclAdminQueue              *AclForYarnQueue      `json:"acl_administer_queue"` //management access control	MaxAllocationMB *int32 `json:"maximum-allocation-mb"` // maximum Memory allocated to Container	MaxAllocationVcores *int32                         `json:"maximum-allocation-vcores"` // the maximum number of Vcores for Container	IsDefault           *bool                          `json:"isDefault"`// whether it is the root.default queue	IsRoot              *bool                          `json:"isRoot"` // whether it is the root queue	Queues              []*QueueForCapacitySchedulerV3 `json:"queues"`//subqueue information. Recursive}type ConfigForCapacityV3 struct {	Name                string          `json:"configName"` // configuration set name	Labels              []CapacityLabel `json:"labels"` // tag information	MinUserLimitPercent *int32          `json:"minimum-user-limit-percent"` // minimum user capacity	UserLimitFactor     *float32        `json:"user-limit-factor" valid:"rangeExcludeLeft(0|)"`  // user resource factor	MaxApps *int32 `json:"maximum-applications" valid:"rangeExcludeLeft(0|)"` // the maximum number of applications Max-Applications	MaxAmPercent               *float32 `json:"maximum-am-resource-percent"` // the maximum AM ratio	DefaultApplicationPriority *int32   `json:"default-application-priority"` // resource pool priority}type CapacityLabel struct {	Name        string   `json:"labelName"`	Capacity    *float32 `json:"capacity"`  // capacity MaxCapacity *float32 `json:"maximum-capacity"` //maximum capacity}type AclForYarnQueue struct {	User  *string `json:"user"` //username	Group *string `json:"group"`//group name}```.
     * @param Queue Queue information. It is a JSON string into which an object is converted. The corresponding Golang structure is as follows. For example, the first field `Name` of `QueueWithConfigSetForFairScheduler: ```Name                         string                               `json:"name"` //queue name ```  - `Name: field name - `string`: field type - `json:"name`:  indicates the corresponding `json key` during serialization/deserialization. Below, `json key` is used for referring.- `//`: the following comment content corresponds to the Name field seen on the page. Fields with types starting with `*` indicate that the value may be null under JSON specifications. Different languages need to be received through a type that can express null, such as Java's wrapper types. Fields with types starting with `[]` indicate an array type, which is used when `json key` calls `ModifyYarnQueueV2` API. - fair scheduler```type QueueWithConfigSetForFairScheduler struct {	Name                         string                               `json:"name"` //queue name MyId                         string                  `json:"myId"` // queue id, used for editing, deleting, and cloning	ParentId                     string                  `json:"parentId"`  // Parent queue Id	Type                         *string                              `json:"type"` // queue affinity. Parent or empty. Setting to be a parent or empty can be performed only when it is confirmed that a queue is a parent queue and has no subqueues. The queue is normally used to support the placement policy nestedUserQueue	AclSubmitApps                *AclForYarnQueue                     `json:"aclSubmitApps"` // submission access control	AclAdministerApps            *AclForYarnQueue                     `json:"aclAdministerApps"` // management access control	MinSharePreemptionTimeout    *int                                 `json:"minSharePreemptionTimeout"` // minimum share preemption timeout period	FairSharePreemptionTimeout   *int                                 `json:"fairSharePreemptionTimeout"` // fair share preemption timeout period	FairSharePreemptionThreshold *float32                             `json:"fairSharePreemptionThreshold"` // fair share preemption threshold. Value range (0, 1]	AllowPreemptionFrom          *bool                                `json:"allowPreemptionFrom"`                                        // preemption mode	SchedulingPolicy             *string                              `json:"schedulingPolicy"`  // scheduling policy with the valid values of drf, fair, and fifo	IsDefault                    *bool                                `json:"isDefault"` // whether it is the root.default queue	IsRoot                       *bool                                `json:"isRoot"` // whether it is the root queue	ConfigSets                   []ConfigSetForFairScheduler          `json:"configSets"` // configuration set settings	Children                     []QueueWithConfigSetForFairScheduler `json:"queues"` // subqueue information. recursive}type AclForYarnQueue struct {	User  *string `json:"user"` //username	Group *string `json:"group"`//group name}type ConfigSetForFairScheduler struct {	Name              string        `json:"name"` // configuration set name	MinResources      *YarnResource `json:"minResources"` // minimum resource amount	MaxResources      *YarnResource `json:"maxResources"` // maximum resource amount	MaxChildResources *YarnResource `json:"maxChildResources"` //.The maximum quantity of resources that can be allocated to undefined subqueues	MaxRunningApps    *int          `json:"maxRunningApps"` // the maximum number of apps that can run concurrently	Weight            *float32      `json:"weight"`                   // Weight	MaxAMShare        *float32      `json:"maxAMShare"` // App Master maximum share}type YarnResource struct {	Vcores *int `json:"vcores"`	Memory *int `json:"memory"`	Type *string `json:"type"` // when the value is `percent`, it indicates usage as a percentage, otherwise an absolute value is used indeed}```- Capacity scheduler```type QueueForCapacitySchedulerV3 struct {	Name                       string                `json:"name"` // queue name	MyId                       string                `json:"myId"` // queue id, used in the case of editing, deleting, or cloning	ParentId                   string                `json:"parentId"` // parent queue id 	Configs                    []ConfigForCapacityV3 `json:"configs"` //configuration set settings	State                      *string         `json:"state"` // resource pool status	DefaultNodeLabelExpression *string               `json:"default-node-label-expression"` // default tag expression	AclSubmitApps              *AclForYarnQueue      `json:"acl_submit_applications"` // submission access control 	AclAdminQueue              *AclForYarnQueue      `json:"acl_administer_queue"` //management access control	MaxAllocationMB *int32 `json:"maximum-allocation-mb"` // maximum Memory allocated to Container	MaxAllocationVcores *int32                         `json:"maximum-allocation-vcores"` // the maximum number of Vcores for Container	IsDefault           *bool                          `json:"isDefault"`// whether it is the root.default queue	IsRoot              *bool                          `json:"isRoot"` // whether it is the root queue	Queues              []*QueueForCapacitySchedulerV3 `json:"queues"`//subqueue information. Recursive}type ConfigForCapacityV3 struct {	Name                string          `json:"configName"` // configuration set name	Labels              []CapacityLabel `json:"labels"` // tag information	MinUserLimitPercent *int32          `json:"minimum-user-limit-percent"` // minimum user capacity	UserLimitFactor     *float32        `json:"user-limit-factor" valid:"rangeExcludeLeft(0|)"`  // user resource factor	MaxApps *int32 `json:"maximum-applications" valid:"rangeExcludeLeft(0|)"` // the maximum number of applications Max-Applications	MaxAmPercent               *float32 `json:"maximum-am-resource-percent"` // the maximum AM ratio	DefaultApplicationPriority *int32   `json:"default-application-priority"` // resource pool priority}type CapacityLabel struct {	Name        string   `json:"labelName"`	Capacity    *float32 `json:"capacity"`  // capacity MaxCapacity *float32 `json:"maximum-capacity"` //maximum capacity}type AclForYarnQueue struct {	User  *string `json:"user"` //username	Group *string `json:"group"`//group name}```.
     */
    public void setQueue(String Queue) {
        this.Queue = Queue;
    }

    /**
     * Get Version 
     * @return Version Version
     */
    public String getVersion() {
        return this.Version;
    }

    /**
     * Set Version
     * @param Version Version
     */
    public void setVersion(String Version) {
        this.Version = Version;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeYarnQueueResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeYarnQueueResponse(DescribeYarnQueueResponse source) {
        if (source.Queue != null) {
            this.Queue = new String(source.Queue);
        }
        if (source.Version != null) {
            this.Version = new String(source.Version);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Queue", this.Queue);
        this.setParamSimple(map, prefix + "Version", this.Version);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

