/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeYarnScheduleHistoryResponse extends AbstractModel {

    /**
    * Task details.

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Tasks")
    @Expose
    private SchedulerTaskInfo [] Tasks;

    /**
    * Total quantity of task details.
    */
    @SerializedName("Total")
    @Expose
    private Long Total;

    /**
    * Scheduling type filter list

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("SchedulerNameList")
    @Expose
    private String [] SchedulerNameList;

    /**
    * Status filter list

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("StateList")
    @Expose
    private Long [] StateList;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Task details.

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Tasks Task details.

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public SchedulerTaskInfo [] getTasks() {
        return this.Tasks;
    }

    /**
     * Set Task details.

Note: This field may return null, indicating that no valid values can be obtained.
     * @param Tasks Task details.

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setTasks(SchedulerTaskInfo [] Tasks) {
        this.Tasks = Tasks;
    }

    /**
     * Get Total quantity of task details. 
     * @return Total Total quantity of task details.
     */
    public Long getTotal() {
        return this.Total;
    }

    /**
     * Set Total quantity of task details.
     * @param Total Total quantity of task details.
     */
    public void setTotal(Long Total) {
        this.Total = Total;
    }

    /**
     * Get Scheduling type filter list

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return SchedulerNameList Scheduling type filter list

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getSchedulerNameList() {
        return this.SchedulerNameList;
    }

    /**
     * Set Scheduling type filter list

Note: This field may return null, indicating that no valid values can be obtained.
     * @param SchedulerNameList Scheduling type filter list

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setSchedulerNameList(String [] SchedulerNameList) {
        this.SchedulerNameList = SchedulerNameList;
    }

    /**
     * Get Status filter list

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return StateList Status filter list

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long [] getStateList() {
        return this.StateList;
    }

    /**
     * Set Status filter list

Note: This field may return null, indicating that no valid values can be obtained.
     * @param StateList Status filter list

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setStateList(Long [] StateList) {
        this.StateList = StateList;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeYarnScheduleHistoryResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeYarnScheduleHistoryResponse(DescribeYarnScheduleHistoryResponse source) {
        if (source.Tasks != null) {
            this.Tasks = new SchedulerTaskInfo[source.Tasks.length];
            for (int i = 0; i < source.Tasks.length; i++) {
                this.Tasks[i] = new SchedulerTaskInfo(source.Tasks[i]);
            }
        }
        if (source.Total != null) {
            this.Total = new Long(source.Total);
        }
        if (source.SchedulerNameList != null) {
            this.SchedulerNameList = new String[source.SchedulerNameList.length];
            for (int i = 0; i < source.SchedulerNameList.length; i++) {
                this.SchedulerNameList[i] = new String(source.SchedulerNameList[i]);
            }
        }
        if (source.StateList != null) {
            this.StateList = new Long[source.StateList.length];
            for (int i = 0; i < source.StateList.length; i++) {
                this.StateList[i] = new Long(source.StateList[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Tasks.", this.Tasks);
        this.setParamSimple(map, prefix + "Total", this.Total);
        this.setParamArraySimple(map, prefix + "SchedulerNameList.", this.SchedulerNameList);
        this.setParamArraySimple(map, prefix + "StateList.", this.StateList);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

