/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class InquiryPriceRenewInstanceResponse extends AbstractModel {

    /**
    * Original price.
    */
    @SerializedName("OriginalCost")
    @Expose
    private Float OriginalCost;

    /**
    * Discounted price.
    */
    @SerializedName("DiscountCost")
    @Expose
    private Float DiscountCost;

    /**
    * Time unit for instance renewal.
    */
    @SerializedName("TimeUnit")
    @Expose
    private String TimeUnit;

    /**
    * Duration of instance renewal.
    */
    @SerializedName("TimeSpan")
    @Expose
    private Long TimeSpan;

    /**
    * Price details.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("PriceDetail")
    @Expose
    private PriceDetail [] PriceDetail;

    /**
    * Node renewal pricing list.
    */
    @SerializedName("NodeRenewPriceDetails")
    @Expose
    private NodeRenewPriceDetail [] NodeRenewPriceDetails;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Original price. 
     * @return OriginalCost Original price.
     */
    public Float getOriginalCost() {
        return this.OriginalCost;
    }

    /**
     * Set Original price.
     * @param OriginalCost Original price.
     */
    public void setOriginalCost(Float OriginalCost) {
        this.OriginalCost = OriginalCost;
    }

    /**
     * Get Discounted price. 
     * @return DiscountCost Discounted price.
     */
    public Float getDiscountCost() {
        return this.DiscountCost;
    }

    /**
     * Set Discounted price.
     * @param DiscountCost Discounted price.
     */
    public void setDiscountCost(Float DiscountCost) {
        this.DiscountCost = DiscountCost;
    }

    /**
     * Get Time unit for instance renewal. 
     * @return TimeUnit Time unit for instance renewal.
     */
    public String getTimeUnit() {
        return this.TimeUnit;
    }

    /**
     * Set Time unit for instance renewal.
     * @param TimeUnit Time unit for instance renewal.
     */
    public void setTimeUnit(String TimeUnit) {
        this.TimeUnit = TimeUnit;
    }

    /**
     * Get Duration of instance renewal. 
     * @return TimeSpan Duration of instance renewal.
     */
    public Long getTimeSpan() {
        return this.TimeSpan;
    }

    /**
     * Set Duration of instance renewal.
     * @param TimeSpan Duration of instance renewal.
     */
    public void setTimeSpan(Long TimeSpan) {
        this.TimeSpan = TimeSpan;
    }

    /**
     * Get Price details.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return PriceDetail Price details.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public PriceDetail [] getPriceDetail() {
        return this.PriceDetail;
    }

    /**
     * Set Price details.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param PriceDetail Price details.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setPriceDetail(PriceDetail [] PriceDetail) {
        this.PriceDetail = PriceDetail;
    }

    /**
     * Get Node renewal pricing list. 
     * @return NodeRenewPriceDetails Node renewal pricing list.
     */
    public NodeRenewPriceDetail [] getNodeRenewPriceDetails() {
        return this.NodeRenewPriceDetails;
    }

    /**
     * Set Node renewal pricing list.
     * @param NodeRenewPriceDetails Node renewal pricing list.
     */
    public void setNodeRenewPriceDetails(NodeRenewPriceDetail [] NodeRenewPriceDetails) {
        this.NodeRenewPriceDetails = NodeRenewPriceDetails;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public InquiryPriceRenewInstanceResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public InquiryPriceRenewInstanceResponse(InquiryPriceRenewInstanceResponse source) {
        if (source.OriginalCost != null) {
            this.OriginalCost = new Float(source.OriginalCost);
        }
        if (source.DiscountCost != null) {
            this.DiscountCost = new Float(source.DiscountCost);
        }
        if (source.TimeUnit != null) {
            this.TimeUnit = new String(source.TimeUnit);
        }
        if (source.TimeSpan != null) {
            this.TimeSpan = new Long(source.TimeSpan);
        }
        if (source.PriceDetail != null) {
            this.PriceDetail = new PriceDetail[source.PriceDetail.length];
            for (int i = 0; i < source.PriceDetail.length; i++) {
                this.PriceDetail[i] = new PriceDetail(source.PriceDetail[i]);
            }
        }
        if (source.NodeRenewPriceDetails != null) {
            this.NodeRenewPriceDetails = new NodeRenewPriceDetail[source.NodeRenewPriceDetails.length];
            for (int i = 0; i < source.NodeRenewPriceDetails.length; i++) {
                this.NodeRenewPriceDetails[i] = new NodeRenewPriceDetail(source.NodeRenewPriceDetails[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "OriginalCost", this.OriginalCost);
        this.setParamSimple(map, prefix + "DiscountCost", this.DiscountCost);
        this.setParamSimple(map, prefix + "TimeUnit", this.TimeUnit);
        this.setParamSimple(map, prefix + "TimeSpan", this.TimeSpan);
        this.setParamArrayObj(map, prefix + "PriceDetail.", this.PriceDetail);
        this.setParamArrayObj(map, prefix + "NodeRenewPriceDetails.", this.NodeRenewPriceDetails);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

