/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class InquiryPriceScaleOutInstanceResponse extends AbstractModel {

    /**
    * Original price.
    */
    @SerializedName("OriginalCost")
    @Expose
    private String OriginalCost;

    /**
    * Discounted price.
    */
    @SerializedName("DiscountCost")
    @Expose
    private String DiscountCost;

    /**
    * Time unit of scale-out. Valid values.
<li>s: second.</li>
    */
    @SerializedName("Unit")
    @Expose
    private String Unit;

    /**
    * Node spec queried for price.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("PriceSpec")
    @Expose
    private PriceResource PriceSpec;

    /**
    * The inquiry results corresponding to the specs specified by the input parameter `MultipleResources`, with the result of the first spec returned by other output parameters.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("MultipleEmrPrice")
    @Expose
    private EmrPrice [] MultipleEmrPrice;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Original price. 
     * @return OriginalCost Original price.
     */
    public String getOriginalCost() {
        return this.OriginalCost;
    }

    /**
     * Set Original price.
     * @param OriginalCost Original price.
     */
    public void setOriginalCost(String OriginalCost) {
        this.OriginalCost = OriginalCost;
    }

    /**
     * Get Discounted price. 
     * @return DiscountCost Discounted price.
     */
    public String getDiscountCost() {
        return this.DiscountCost;
    }

    /**
     * Set Discounted price.
     * @param DiscountCost Discounted price.
     */
    public void setDiscountCost(String DiscountCost) {
        this.DiscountCost = DiscountCost;
    }

    /**
     * Get Time unit of scale-out. Valid values.
<li>s: second.</li> 
     * @return Unit Time unit of scale-out. Valid values.
<li>s: second.</li>
     */
    public String getUnit() {
        return this.Unit;
    }

    /**
     * Set Time unit of scale-out. Valid values.
<li>s: second.</li>
     * @param Unit Time unit of scale-out. Valid values.
<li>s: second.</li>
     */
    public void setUnit(String Unit) {
        this.Unit = Unit;
    }

    /**
     * Get Node spec queried for price.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return PriceSpec Node spec queried for price.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public PriceResource getPriceSpec() {
        return this.PriceSpec;
    }

    /**
     * Set Node spec queried for price.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param PriceSpec Node spec queried for price.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setPriceSpec(PriceResource PriceSpec) {
        this.PriceSpec = PriceSpec;
    }

    /**
     * Get The inquiry results corresponding to the specs specified by the input parameter `MultipleResources`, with the result of the first spec returned by other output parameters.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return MultipleEmrPrice The inquiry results corresponding to the specs specified by the input parameter `MultipleResources`, with the result of the first spec returned by other output parameters.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public EmrPrice [] getMultipleEmrPrice() {
        return this.MultipleEmrPrice;
    }

    /**
     * Set The inquiry results corresponding to the specs specified by the input parameter `MultipleResources`, with the result of the first spec returned by other output parameters.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param MultipleEmrPrice The inquiry results corresponding to the specs specified by the input parameter `MultipleResources`, with the result of the first spec returned by other output parameters.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setMultipleEmrPrice(EmrPrice [] MultipleEmrPrice) {
        this.MultipleEmrPrice = MultipleEmrPrice;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public InquiryPriceScaleOutInstanceResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public InquiryPriceScaleOutInstanceResponse(InquiryPriceScaleOutInstanceResponse source) {
        if (source.OriginalCost != null) {
            this.OriginalCost = new String(source.OriginalCost);
        }
        if (source.DiscountCost != null) {
            this.DiscountCost = new String(source.DiscountCost);
        }
        if (source.Unit != null) {
            this.Unit = new String(source.Unit);
        }
        if (source.PriceSpec != null) {
            this.PriceSpec = new PriceResource(source.PriceSpec);
        }
        if (source.MultipleEmrPrice != null) {
            this.MultipleEmrPrice = new EmrPrice[source.MultipleEmrPrice.length];
            for (int i = 0; i < source.MultipleEmrPrice.length; i++) {
                this.MultipleEmrPrice[i] = new EmrPrice(source.MultipleEmrPrice[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "OriginalCost", this.OriginalCost);
        this.setParamSimple(map, prefix + "DiscountCost", this.DiscountCost);
        this.setParamSimple(map, prefix + "Unit", this.Unit);
        this.setParamObj(map, prefix + "PriceSpec.", this.PriceSpec);
        this.setParamArrayObj(map, prefix + "MultipleEmrPrice.", this.MultipleEmrPrice);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

