/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class InquiryPriceUpdateInstanceResponse extends AbstractModel {

    /**
    * Original price.
    */
    @SerializedName("OriginalCost")
    @Expose
    private Float OriginalCost;

    /**
    * Discounted price.
    */
    @SerializedName("DiscountCost")
    @Expose
    private Float DiscountCost;

    /**
    * Time unit of resizing. Valid values:
<li>s: second.</li>
    */
    @SerializedName("TimeUnit")
    @Expose
    private String TimeUnit;

    /**
    * Desizing duration.
    */
    @SerializedName("TimeSpan")
    @Expose
    private Long TimeSpan;

    /**
    * Pricing details
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("PriceDetail")
    @Expose
    private PriceDetail [] PriceDetail;

    /**
    * New configuration price.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("NewConfigPrice")
    @Expose
    private PriceResult NewConfigPrice;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Original price. 
     * @return OriginalCost Original price.
     */
    public Float getOriginalCost() {
        return this.OriginalCost;
    }

    /**
     * Set Original price.
     * @param OriginalCost Original price.
     */
    public void setOriginalCost(Float OriginalCost) {
        this.OriginalCost = OriginalCost;
    }

    /**
     * Get Discounted price. 
     * @return DiscountCost Discounted price.
     */
    public Float getDiscountCost() {
        return this.DiscountCost;
    }

    /**
     * Set Discounted price.
     * @param DiscountCost Discounted price.
     */
    public void setDiscountCost(Float DiscountCost) {
        this.DiscountCost = DiscountCost;
    }

    /**
     * Get Time unit of resizing. Valid values:
<li>s: second.</li> 
     * @return TimeUnit Time unit of resizing. Valid values:
<li>s: second.</li>
     */
    public String getTimeUnit() {
        return this.TimeUnit;
    }

    /**
     * Set Time unit of resizing. Valid values:
<li>s: second.</li>
     * @param TimeUnit Time unit of resizing. Valid values:
<li>s: second.</li>
     */
    public void setTimeUnit(String TimeUnit) {
        this.TimeUnit = TimeUnit;
    }

    /**
     * Get Desizing duration. 
     * @return TimeSpan Desizing duration.
     */
    public Long getTimeSpan() {
        return this.TimeSpan;
    }

    /**
     * Set Desizing duration.
     * @param TimeSpan Desizing duration.
     */
    public void setTimeSpan(Long TimeSpan) {
        this.TimeSpan = TimeSpan;
    }

    /**
     * Get Pricing details
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return PriceDetail Pricing details
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public PriceDetail [] getPriceDetail() {
        return this.PriceDetail;
    }

    /**
     * Set Pricing details
Note: This field may return null, indicating that no valid values can be obtained.
     * @param PriceDetail Pricing details
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setPriceDetail(PriceDetail [] PriceDetail) {
        this.PriceDetail = PriceDetail;
    }

    /**
     * Get New configuration price.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return NewConfigPrice New configuration price.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public PriceResult getNewConfigPrice() {
        return this.NewConfigPrice;
    }

    /**
     * Set New configuration price.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param NewConfigPrice New configuration price.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setNewConfigPrice(PriceResult NewConfigPrice) {
        this.NewConfigPrice = NewConfigPrice;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public InquiryPriceUpdateInstanceResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public InquiryPriceUpdateInstanceResponse(InquiryPriceUpdateInstanceResponse source) {
        if (source.OriginalCost != null) {
            this.OriginalCost = new Float(source.OriginalCost);
        }
        if (source.DiscountCost != null) {
            this.DiscountCost = new Float(source.DiscountCost);
        }
        if (source.TimeUnit != null) {
            this.TimeUnit = new String(source.TimeUnit);
        }
        if (source.TimeSpan != null) {
            this.TimeSpan = new Long(source.TimeSpan);
        }
        if (source.PriceDetail != null) {
            this.PriceDetail = new PriceDetail[source.PriceDetail.length];
            for (int i = 0; i < source.PriceDetail.length; i++) {
                this.PriceDetail[i] = new PriceDetail(source.PriceDetail[i]);
            }
        }
        if (source.NewConfigPrice != null) {
            this.NewConfigPrice = new PriceResult(source.NewConfigPrice);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "OriginalCost", this.OriginalCost);
        this.setParamSimple(map, prefix + "DiscountCost", this.DiscountCost);
        this.setParamSimple(map, prefix + "TimeUnit", this.TimeUnit);
        this.setParamSimple(map, prefix + "TimeSpan", this.TimeSpan);
        this.setParamArrayObj(map, prefix + "PriceDetail.", this.PriceDetail);
        this.setParamObj(map, prefix + "NewConfigPrice.", this.NewConfigPrice);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

