/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class TaskSettings extends AbstractModel {

    /**
    * Parameter name.
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
    * Parameter value.
    */
    @SerializedName("Value")
    @Expose
    private String Value;

    /**
    * Unique parameter identifier.
    */
    @SerializedName("Key")
    @Expose
    private String Key;

    /**
    * Whether it is editable, "true" or "false".
    */
    @SerializedName("Editable")
    @Expose
    private String Editable;

    /**
     * Get Parameter name. 
     * @return Name Parameter name.
     */
    public String getName() {
        return this.Name;
    }

    /**
     * Set Parameter name.
     * @param Name Parameter name.
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    /**
     * Get Parameter value. 
     * @return Value Parameter value.
     */
    public String getValue() {
        return this.Value;
    }

    /**
     * Set Parameter value.
     * @param Value Parameter value.
     */
    public void setValue(String Value) {
        this.Value = Value;
    }

    /**
     * Get Unique parameter identifier. 
     * @return Key Unique parameter identifier.
     */
    public String getKey() {
        return this.Key;
    }

    /**
     * Set Unique parameter identifier.
     * @param Key Unique parameter identifier.
     */
    public void setKey(String Key) {
        this.Key = Key;
    }

    /**
     * Get Whether it is editable, "true" or "false". 
     * @return Editable Whether it is editable, "true" or "false".
     */
    public String getEditable() {
        return this.Editable;
    }

    /**
     * Set Whether it is editable, "true" or "false".
     * @param Editable Whether it is editable, "true" or "false".
     */
    public void setEditable(String Editable) {
        this.Editable = Editable;
    }

    public TaskSettings() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public TaskSettings(TaskSettings source) {
        if (source.Name != null) {
            this.Name = new String(source.Name);
        }
        if (source.Value != null) {
            this.Value = new String(source.Value);
        }
        if (source.Key != null) {
            this.Key = new String(source.Key);
        }
        if (source.Editable != null) {
            this.Editable = new String(source.Editable);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Name", this.Name);
        this.setParamSimple(map, prefix + "Value", this.Value);
        this.setParamSimple(map, prefix + "Key", this.Key);
        this.setParamSimple(map, prefix + "Editable", this.Editable);

    }
}

