/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.emr.v20190103.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ZoneResourceConfiguration extends AbstractModel {

    /**
    * The VPC configuration information. This parameter is used to specify the VPC ID, subnet ID and other information.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("VirtualPrivateCloud")
    @Expose
    private VirtualPrivateCloud VirtualPrivateCloud;

    /**
    * The instance location. This parameter is used to specify the AZ, project, and other attributes of the instance.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Placement")
    @Expose
    private Placement Placement;

    /**
    * The specs of all nodes.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("AllNodeResourceSpec")
    @Expose
    private AllNodeResourceSpec AllNodeResourceSpec;

    /**
    * Leave ZoneTag empty in the case of a single availability zone. In the case of a dual-AZ deployment, select master for the first availability zone's ZoneTag and standby for the second. In the case of a three-AZ deployment, select master for the first availability zone's ZoneTag, standby for the second, and third-party for the third. Valid values.
  <li>master</li>
  <li>standby</li>
  <li>third-party</li>
    */
    @SerializedName("ZoneTag")
    @Expose
    private String ZoneTag;

    /**
     * Get The VPC configuration information. This parameter is used to specify the VPC ID, subnet ID and other information.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return VirtualPrivateCloud The VPC configuration information. This parameter is used to specify the VPC ID, subnet ID and other information.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public VirtualPrivateCloud getVirtualPrivateCloud() {
        return this.VirtualPrivateCloud;
    }

    /**
     * Set The VPC configuration information. This parameter is used to specify the VPC ID, subnet ID and other information.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param VirtualPrivateCloud The VPC configuration information. This parameter is used to specify the VPC ID, subnet ID and other information.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setVirtualPrivateCloud(VirtualPrivateCloud VirtualPrivateCloud) {
        this.VirtualPrivateCloud = VirtualPrivateCloud;
    }

    /**
     * Get The instance location. This parameter is used to specify the AZ, project, and other attributes of the instance.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Placement The instance location. This parameter is used to specify the AZ, project, and other attributes of the instance.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Placement getPlacement() {
        return this.Placement;
    }

    /**
     * Set The instance location. This parameter is used to specify the AZ, project, and other attributes of the instance.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Placement The instance location. This parameter is used to specify the AZ, project, and other attributes of the instance.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setPlacement(Placement Placement) {
        this.Placement = Placement;
    }

    /**
     * Get The specs of all nodes.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return AllNodeResourceSpec The specs of all nodes.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public AllNodeResourceSpec getAllNodeResourceSpec() {
        return this.AllNodeResourceSpec;
    }

    /**
     * Set The specs of all nodes.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param AllNodeResourceSpec The specs of all nodes.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setAllNodeResourceSpec(AllNodeResourceSpec AllNodeResourceSpec) {
        this.AllNodeResourceSpec = AllNodeResourceSpec;
    }

    /**
     * Get Leave ZoneTag empty in the case of a single availability zone. In the case of a dual-AZ deployment, select master for the first availability zone's ZoneTag and standby for the second. In the case of a three-AZ deployment, select master for the first availability zone's ZoneTag, standby for the second, and third-party for the third. Valid values.
  <li>master</li>
  <li>standby</li>
  <li>third-party</li> 
     * @return ZoneTag Leave ZoneTag empty in the case of a single availability zone. In the case of a dual-AZ deployment, select master for the first availability zone's ZoneTag and standby for the second. In the case of a three-AZ deployment, select master for the first availability zone's ZoneTag, standby for the second, and third-party for the third. Valid values.
  <li>master</li>
  <li>standby</li>
  <li>third-party</li>
     */
    public String getZoneTag() {
        return this.ZoneTag;
    }

    /**
     * Set Leave ZoneTag empty in the case of a single availability zone. In the case of a dual-AZ deployment, select master for the first availability zone's ZoneTag and standby for the second. In the case of a three-AZ deployment, select master for the first availability zone's ZoneTag, standby for the second, and third-party for the third. Valid values.
  <li>master</li>
  <li>standby</li>
  <li>third-party</li>
     * @param ZoneTag Leave ZoneTag empty in the case of a single availability zone. In the case of a dual-AZ deployment, select master for the first availability zone's ZoneTag and standby for the second. In the case of a three-AZ deployment, select master for the first availability zone's ZoneTag, standby for the second, and third-party for the third. Valid values.
  <li>master</li>
  <li>standby</li>
  <li>third-party</li>
     */
    public void setZoneTag(String ZoneTag) {
        this.ZoneTag = ZoneTag;
    }

    public ZoneResourceConfiguration() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ZoneResourceConfiguration(ZoneResourceConfiguration source) {
        if (source.VirtualPrivateCloud != null) {
            this.VirtualPrivateCloud = new VirtualPrivateCloud(source.VirtualPrivateCloud);
        }
        if (source.Placement != null) {
            this.Placement = new Placement(source.Placement);
        }
        if (source.AllNodeResourceSpec != null) {
            this.AllNodeResourceSpec = new AllNodeResourceSpec(source.AllNodeResourceSpec);
        }
        if (source.ZoneTag != null) {
            this.ZoneTag = new String(source.ZoneTag);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "VirtualPrivateCloud.", this.VirtualPrivateCloud);
        this.setParamObj(map, prefix + "Placement.", this.Placement);
        this.setParamObj(map, prefix + "AllNodeResourceSpec.", this.AllNodeResourceSpec);
        this.setParamSimple(map, prefix + "ZoneTag", this.ZoneTag);

    }
}

