/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.facefusion.v20220927.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class QueryVideoFaceFusionJobResponse extends AbstractModel {

    /**
    * Current task status: queuing, processing, processing failed, or processing completed
    */
    @SerializedName("JobStatus")
    @Expose
    private String JobStatus;

    /**
    * Video face fusion result
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("VideoFaceFusionOutput")
    @Expose
    private VideoFaceFusionOutput VideoFaceFusionOutput;

    /**
    * Task status code. 1: queuing; 3: processing; 5: processing failed; 7: processing completed.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("JobStatusCode")
    @Expose
    private Long JobStatusCode;

    /**
    * Task failure error code
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("JobErrorCode")
    @Expose
    private String JobErrorCode;

    /**
    * Task failure error message
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("JobErrorMsg")
    @Expose
    private String JobErrorMsg;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Current task status: queuing, processing, processing failed, or processing completed 
     * @return JobStatus Current task status: queuing, processing, processing failed, or processing completed
     */
    public String getJobStatus() {
        return this.JobStatus;
    }

    /**
     * Set Current task status: queuing, processing, processing failed, or processing completed
     * @param JobStatus Current task status: queuing, processing, processing failed, or processing completed
     */
    public void setJobStatus(String JobStatus) {
        this.JobStatus = JobStatus;
    }

    /**
     * Get Video face fusion result
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return VideoFaceFusionOutput Video face fusion result
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public VideoFaceFusionOutput getVideoFaceFusionOutput() {
        return this.VideoFaceFusionOutput;
    }

    /**
     * Set Video face fusion result
Note: This field may return null, indicating that no valid values can be obtained.
     * @param VideoFaceFusionOutput Video face fusion result
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setVideoFaceFusionOutput(VideoFaceFusionOutput VideoFaceFusionOutput) {
        this.VideoFaceFusionOutput = VideoFaceFusionOutput;
    }

    /**
     * Get Task status code. 1: queuing; 3: processing; 5: processing failed; 7: processing completed.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return JobStatusCode Task status code. 1: queuing; 3: processing; 5: processing failed; 7: processing completed.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getJobStatusCode() {
        return this.JobStatusCode;
    }

    /**
     * Set Task status code. 1: queuing; 3: processing; 5: processing failed; 7: processing completed.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param JobStatusCode Task status code. 1: queuing; 3: processing; 5: processing failed; 7: processing completed.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setJobStatusCode(Long JobStatusCode) {
        this.JobStatusCode = JobStatusCode;
    }

    /**
     * Get Task failure error code
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return JobErrorCode Task failure error code
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getJobErrorCode() {
        return this.JobErrorCode;
    }

    /**
     * Set Task failure error code
Note: This field may return null, indicating that no valid values can be obtained.
     * @param JobErrorCode Task failure error code
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setJobErrorCode(String JobErrorCode) {
        this.JobErrorCode = JobErrorCode;
    }

    /**
     * Get Task failure error message
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return JobErrorMsg Task failure error message
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getJobErrorMsg() {
        return this.JobErrorMsg;
    }

    /**
     * Set Task failure error message
Note: This field may return null, indicating that no valid values can be obtained.
     * @param JobErrorMsg Task failure error message
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setJobErrorMsg(String JobErrorMsg) {
        this.JobErrorMsg = JobErrorMsg;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public QueryVideoFaceFusionJobResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public QueryVideoFaceFusionJobResponse(QueryVideoFaceFusionJobResponse source) {
        if (source.JobStatus != null) {
            this.JobStatus = new String(source.JobStatus);
        }
        if (source.VideoFaceFusionOutput != null) {
            this.VideoFaceFusionOutput = new VideoFaceFusionOutput(source.VideoFaceFusionOutput);
        }
        if (source.JobStatusCode != null) {
            this.JobStatusCode = new Long(source.JobStatusCode);
        }
        if (source.JobErrorCode != null) {
            this.JobErrorCode = new String(source.JobErrorCode);
        }
        if (source.JobErrorMsg != null) {
            this.JobErrorMsg = new String(source.JobErrorMsg);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "JobStatus", this.JobStatus);
        this.setParamObj(map, prefix + "VideoFaceFusionOutput.", this.VideoFaceFusionOutput);
        this.setParamSimple(map, prefix + "JobStatusCode", this.JobStatusCode);
        this.setParamSimple(map, prefix + "JobErrorCode", this.JobErrorCode);
        this.setParamSimple(map, prefix + "JobErrorMsg", this.JobErrorMsg);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

