/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.faceid.v20180301.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CompareFaceLivenessResponse extends AbstractModel {

    /**
    * Business Error Codes.
-When the return value is "Success", it indicates that liveness detection and face comparison passed. Determined to be the same person.
-When the return value is "FailedOperation.CompareLowSimilarity", it indicates that liveness detection passed, but face comparison similarity is below 70. Determined not to be the same person.
-For other error cases, please refer to [Liveness Face Comparison (API only) Error Codes](https://www.tencentcloud.com/zh/document/product/1061/55390?lang=zh&pg=#97df7537-87fe-4266-87e9-02c816d41ee2)
    */
    @SerializedName("Result")
    @Expose
    private String Result;

    /**
    * The service result description
    */
    @SerializedName("Description")
    @Expose
    private String Description;

    /**
    * This value indicates the similarity of face comparison. Value range: 0.00-100.00.
- The false acceptance rate for a threshold of 70 is 0.1%, and for a threshold of 80, it is 0.01%.
- This value is valid when the Result parameter is "Success" or "FailedOperation.CompareLowSimilarity".
    */
    @SerializedName("Sim")
    @Expose
    private Float Sim;

    /**
    * The best screenshot photo from the video after verification, encoded in BASE64, in jpg format.
The optimal screenshot of the video after verification is the value encoded by BASE64, jpg format. 
Note: This field may return "null", indicating that no valid value can be obtained. 
Example values: "/9j/4AAQSk... (total length:142036)s97n//2Q=="
    */
    @SerializedName("BestFrameBase64")
    @Expose
    private String BestFrameBase64;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Business Error Codes.
-When the return value is "Success", it indicates that liveness detection and face comparison passed. Determined to be the same person.
-When the return value is "FailedOperation.CompareLowSimilarity", it indicates that liveness detection passed, but face comparison similarity is below 70. Determined not to be the same person.
-For other error cases, please refer to [Liveness Face Comparison (API only) Error Codes](https://www.tencentcloud.com/zh/document/product/1061/55390?lang=zh&pg=#97df7537-87fe-4266-87e9-02c816d41ee2) 
     * @return Result Business Error Codes.
-When the return value is "Success", it indicates that liveness detection and face comparison passed. Determined to be the same person.
-When the return value is "FailedOperation.CompareLowSimilarity", it indicates that liveness detection passed, but face comparison similarity is below 70. Determined not to be the same person.
-For other error cases, please refer to [Liveness Face Comparison (API only) Error Codes](https://www.tencentcloud.com/zh/document/product/1061/55390?lang=zh&pg=#97df7537-87fe-4266-87e9-02c816d41ee2)
     */
    public String getResult() {
        return this.Result;
    }

    /**
     * Set Business Error Codes.
-When the return value is "Success", it indicates that liveness detection and face comparison passed. Determined to be the same person.
-When the return value is "FailedOperation.CompareLowSimilarity", it indicates that liveness detection passed, but face comparison similarity is below 70. Determined not to be the same person.
-For other error cases, please refer to [Liveness Face Comparison (API only) Error Codes](https://www.tencentcloud.com/zh/document/product/1061/55390?lang=zh&pg=#97df7537-87fe-4266-87e9-02c816d41ee2)
     * @param Result Business Error Codes.
-When the return value is "Success", it indicates that liveness detection and face comparison passed. Determined to be the same person.
-When the return value is "FailedOperation.CompareLowSimilarity", it indicates that liveness detection passed, but face comparison similarity is below 70. Determined not to be the same person.
-For other error cases, please refer to [Liveness Face Comparison (API only) Error Codes](https://www.tencentcloud.com/zh/document/product/1061/55390?lang=zh&pg=#97df7537-87fe-4266-87e9-02c816d41ee2)
     */
    public void setResult(String Result) {
        this.Result = Result;
    }

    /**
     * Get The service result description 
     * @return Description The service result description
     */
    public String getDescription() {
        return this.Description;
    }

    /**
     * Set The service result description
     * @param Description The service result description
     */
    public void setDescription(String Description) {
        this.Description = Description;
    }

    /**
     * Get This value indicates the similarity of face comparison. Value range: 0.00-100.00.
- The false acceptance rate for a threshold of 70 is 0.1%, and for a threshold of 80, it is 0.01%.
- This value is valid when the Result parameter is "Success" or "FailedOperation.CompareLowSimilarity". 
     * @return Sim This value indicates the similarity of face comparison. Value range: 0.00-100.00.
- The false acceptance rate for a threshold of 70 is 0.1%, and for a threshold of 80, it is 0.01%.
- This value is valid when the Result parameter is "Success" or "FailedOperation.CompareLowSimilarity".
     */
    public Float getSim() {
        return this.Sim;
    }

    /**
     * Set This value indicates the similarity of face comparison. Value range: 0.00-100.00.
- The false acceptance rate for a threshold of 70 is 0.1%, and for a threshold of 80, it is 0.01%.
- This value is valid when the Result parameter is "Success" or "FailedOperation.CompareLowSimilarity".
     * @param Sim This value indicates the similarity of face comparison. Value range: 0.00-100.00.
- The false acceptance rate for a threshold of 70 is 0.1%, and for a threshold of 80, it is 0.01%.
- This value is valid when the Result parameter is "Success" or "FailedOperation.CompareLowSimilarity".
     */
    public void setSim(Float Sim) {
        this.Sim = Sim;
    }

    /**
     * Get The best screenshot photo from the video after verification, encoded in BASE64, in jpg format.
The optimal screenshot of the video after verification is the value encoded by BASE64, jpg format. 
Note: This field may return "null", indicating that no valid value can be obtained. 
Example values: "/9j/4AAQSk... (total length:142036)s97n//2Q==" 
     * @return BestFrameBase64 The best screenshot photo from the video after verification, encoded in BASE64, in jpg format.
The optimal screenshot of the video after verification is the value encoded by BASE64, jpg format. 
Note: This field may return "null", indicating that no valid value can be obtained. 
Example values: "/9j/4AAQSk... (total length:142036)s97n//2Q=="
     */
    public String getBestFrameBase64() {
        return this.BestFrameBase64;
    }

    /**
     * Set The best screenshot photo from the video after verification, encoded in BASE64, in jpg format.
The optimal screenshot of the video after verification is the value encoded by BASE64, jpg format. 
Note: This field may return "null", indicating that no valid value can be obtained. 
Example values: "/9j/4AAQSk... (total length:142036)s97n//2Q=="
     * @param BestFrameBase64 The best screenshot photo from the video after verification, encoded in BASE64, in jpg format.
The optimal screenshot of the video after verification is the value encoded by BASE64, jpg format. 
Note: This field may return "null", indicating that no valid value can be obtained. 
Example values: "/9j/4AAQSk... (total length:142036)s97n//2Q=="
     */
    public void setBestFrameBase64(String BestFrameBase64) {
        this.BestFrameBase64 = BestFrameBase64;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public CompareFaceLivenessResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CompareFaceLivenessResponse(CompareFaceLivenessResponse source) {
        if (source.Result != null) {
            this.Result = new String(source.Result);
        }
        if (source.Description != null) {
            this.Description = new String(source.Description);
        }
        if (source.Sim != null) {
            this.Sim = new Float(source.Sim);
        }
        if (source.BestFrameBase64 != null) {
            this.BestFrameBase64 = new String(source.BestFrameBase64);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Result", this.Result);
        this.setParamSimple(map, prefix + "Description", this.Description);
        this.setParamSimple(map, prefix + "Sim", this.Sim);
        this.setParamSimple(map, prefix + "BestFrameBase64", this.BestFrameBase64);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

