/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.faceid.v20180301.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DetectReflectLivenessAndCompareRequest extends AbstractModel {

    /**
    * URL of the liveness detection data package generated by the SDK
    */
    @SerializedName("LiveDataUrl")
    @Expose
    private String LiveDataUrl;

    /**
    * MD5 hash value (32-bit) of the liveness detection data package generated by the SDK, which is used to verify the LiveData consistency.
    */
    @SerializedName("LiveDataMd5")
    @Expose
    private String LiveDataMd5;

    /**
    * URL of the target image for comparison
    */
    @SerializedName("ImageUrl")
    @Expose
    private String ImageUrl;

    /**
    * MD5 hash value (32-bit) of the target image for comparison, which is used to verify the `Image` consistency.
    */
    @SerializedName("ImageMd5")
    @Expose
    private String ImageMd5;

    /**
     * Get URL of the liveness detection data package generated by the SDK 
     * @return LiveDataUrl URL of the liveness detection data package generated by the SDK
     */
    public String getLiveDataUrl() {
        return this.LiveDataUrl;
    }

    /**
     * Set URL of the liveness detection data package generated by the SDK
     * @param LiveDataUrl URL of the liveness detection data package generated by the SDK
     */
    public void setLiveDataUrl(String LiveDataUrl) {
        this.LiveDataUrl = LiveDataUrl;
    }

    /**
     * Get MD5 hash value (32-bit) of the liveness detection data package generated by the SDK, which is used to verify the LiveData consistency. 
     * @return LiveDataMd5 MD5 hash value (32-bit) of the liveness detection data package generated by the SDK, which is used to verify the LiveData consistency.
     */
    public String getLiveDataMd5() {
        return this.LiveDataMd5;
    }

    /**
     * Set MD5 hash value (32-bit) of the liveness detection data package generated by the SDK, which is used to verify the LiveData consistency.
     * @param LiveDataMd5 MD5 hash value (32-bit) of the liveness detection data package generated by the SDK, which is used to verify the LiveData consistency.
     */
    public void setLiveDataMd5(String LiveDataMd5) {
        this.LiveDataMd5 = LiveDataMd5;
    }

    /**
     * Get URL of the target image for comparison 
     * @return ImageUrl URL of the target image for comparison
     */
    public String getImageUrl() {
        return this.ImageUrl;
    }

    /**
     * Set URL of the target image for comparison
     * @param ImageUrl URL of the target image for comparison
     */
    public void setImageUrl(String ImageUrl) {
        this.ImageUrl = ImageUrl;
    }

    /**
     * Get MD5 hash value (32-bit) of the target image for comparison, which is used to verify the `Image` consistency. 
     * @return ImageMd5 MD5 hash value (32-bit) of the target image for comparison, which is used to verify the `Image` consistency.
     */
    public String getImageMd5() {
        return this.ImageMd5;
    }

    /**
     * Set MD5 hash value (32-bit) of the target image for comparison, which is used to verify the `Image` consistency.
     * @param ImageMd5 MD5 hash value (32-bit) of the target image for comparison, which is used to verify the `Image` consistency.
     */
    public void setImageMd5(String ImageMd5) {
        this.ImageMd5 = ImageMd5;
    }

    public DetectReflectLivenessAndCompareRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DetectReflectLivenessAndCompareRequest(DetectReflectLivenessAndCompareRequest source) {
        if (source.LiveDataUrl != null) {
            this.LiveDataUrl = new String(source.LiveDataUrl);
        }
        if (source.LiveDataMd5 != null) {
            this.LiveDataMd5 = new String(source.LiveDataMd5);
        }
        if (source.ImageUrl != null) {
            this.ImageUrl = new String(source.ImageUrl);
        }
        if (source.ImageMd5 != null) {
            this.ImageMd5 = new String(source.ImageMd5);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "LiveDataUrl", this.LiveDataUrl);
        this.setParamSimple(map, prefix + "LiveDataMd5", this.LiveDataMd5);
        this.setParamSimple(map, prefix + "ImageUrl", this.ImageUrl);
        this.setParamSimple(map, prefix + "ImageMd5", this.ImageMd5);

    }
}

