/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.faceid.v20180301.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GenerateReflectSequenceRequest extends AbstractModel {

    /**
    * The resource URL of the data package generated by the SDK.
    */
    @SerializedName("DeviceDataUrl")
    @Expose
    private String DeviceDataUrl;

    /**
    * The MD5 hash value of the data package generated by the SDK.
    */
    @SerializedName("DeviceDataMd5")
    @Expose
    private String DeviceDataMd5;

    /**
    * 1 - silent
2 - blinking
3 - light
4 - blinking + light (default)
    */
    @SerializedName("SecurityLevel")
    @Expose
    private String SecurityLevel;

    /**
     * Get The resource URL of the data package generated by the SDK. 
     * @return DeviceDataUrl The resource URL of the data package generated by the SDK.
     */
    public String getDeviceDataUrl() {
        return this.DeviceDataUrl;
    }

    /**
     * Set The resource URL of the data package generated by the SDK.
     * @param DeviceDataUrl The resource URL of the data package generated by the SDK.
     */
    public void setDeviceDataUrl(String DeviceDataUrl) {
        this.DeviceDataUrl = DeviceDataUrl;
    }

    /**
     * Get The MD5 hash value of the data package generated by the SDK. 
     * @return DeviceDataMd5 The MD5 hash value of the data package generated by the SDK.
     */
    public String getDeviceDataMd5() {
        return this.DeviceDataMd5;
    }

    /**
     * Set The MD5 hash value of the data package generated by the SDK.
     * @param DeviceDataMd5 The MD5 hash value of the data package generated by the SDK.
     */
    public void setDeviceDataMd5(String DeviceDataMd5) {
        this.DeviceDataMd5 = DeviceDataMd5;
    }

    /**
     * Get 1 - silent
2 - blinking
3 - light
4 - blinking + light (default) 
     * @return SecurityLevel 1 - silent
2 - blinking
3 - light
4 - blinking + light (default)
     */
    public String getSecurityLevel() {
        return this.SecurityLevel;
    }

    /**
     * Set 1 - silent
2 - blinking
3 - light
4 - blinking + light (default)
     * @param SecurityLevel 1 - silent
2 - blinking
3 - light
4 - blinking + light (default)
     */
    public void setSecurityLevel(String SecurityLevel) {
        this.SecurityLevel = SecurityLevel;
    }

    public GenerateReflectSequenceRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GenerateReflectSequenceRequest(GenerateReflectSequenceRequest source) {
        if (source.DeviceDataUrl != null) {
            this.DeviceDataUrl = new String(source.DeviceDataUrl);
        }
        if (source.DeviceDataMd5 != null) {
            this.DeviceDataMd5 = new String(source.DeviceDataMd5);
        }
        if (source.SecurityLevel != null) {
            this.SecurityLevel = new String(source.SecurityLevel);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "DeviceDataUrl", this.DeviceDataUrl);
        this.setParamSimple(map, prefix + "DeviceDataMd5", this.DeviceDataMd5);
        this.setParamSimple(map, prefix + "SecurityLevel", this.SecurityLevel);

    }
}

