/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.faceid.v20180301.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GetFaceIdResultIntlResponse extends AbstractModel {

    /**
    * The return code of the verification result.
0: Succeeded.
1001: System error.
1004: Selfie verification comparison failed.
2004: The image passed in is too large or too small.
2012: Several faces were detected.
2013: No face was detected, or the face detected was incomplete.
2014: The image resolution is too low or the quality does not meet the requirements.
2015: Face comparison failed.
2016: The similarity did not reach the standard passing threshold.
-999: The verification process wasn't finished.
    */
    @SerializedName("Result")
    @Expose
    private String Result;

    /**
    * The description of the verification result.
    */
    @SerializedName("Description")
    @Expose
    private String Description;

    /**
    * The best frame screenshot (in Base64) obtained during the verification.
    */
    @SerializedName("BestFrame")
    @Expose
    private String BestFrame;

    /**
    * The video file (Base64) for verification.Used for verification, contains specific color reflection effects.
    */
    @SerializedName("Video")
    @Expose
    private String Video;

    /**
    * Records the specific action performed by the user, used for AI Face Shield analysis.
    */
    @SerializedName("ActionVideo")
    @Expose
    private String ActionVideo;

    /**
    * The similarity, with a value range of 0-100. A greater value indicates higher similarity. This parameter is returned only in the `compare` (selfie verification) mode.
Note: This field may return `null`, indicating that no valid values can be obtained.
    */
    @SerializedName("Similarity")
    @Expose
    private Float Similarity;

    /**
    * The pass-through parameter.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Extra")
    @Expose
    private String Extra;

    /**
    * Describe the risk level of the device where the current request is located, with a total of 4 levels. The details are as follows:
1 - Secure
2 - Low Risk
3 - Medium Risk
4 - High Risk
Empty - Risk level not obtained.
Only returned for the ENHANCED version, with the default value being empty.
    */
    @SerializedName("DeviceInfoLevel")
    @Expose
    private String DeviceInfoLevel;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get The return code of the verification result.
0: Succeeded.
1001: System error.
1004: Selfie verification comparison failed.
2004: The image passed in is too large or too small.
2012: Several faces were detected.
2013: No face was detected, or the face detected was incomplete.
2014: The image resolution is too low or the quality does not meet the requirements.
2015: Face comparison failed.
2016: The similarity did not reach the standard passing threshold.
-999: The verification process wasn't finished. 
     * @return Result The return code of the verification result.
0: Succeeded.
1001: System error.
1004: Selfie verification comparison failed.
2004: The image passed in is too large or too small.
2012: Several faces were detected.
2013: No face was detected, or the face detected was incomplete.
2014: The image resolution is too low or the quality does not meet the requirements.
2015: Face comparison failed.
2016: The similarity did not reach the standard passing threshold.
-999: The verification process wasn't finished.
     */
    public String getResult() {
        return this.Result;
    }

    /**
     * Set The return code of the verification result.
0: Succeeded.
1001: System error.
1004: Selfie verification comparison failed.
2004: The image passed in is too large or too small.
2012: Several faces were detected.
2013: No face was detected, or the face detected was incomplete.
2014: The image resolution is too low or the quality does not meet the requirements.
2015: Face comparison failed.
2016: The similarity did not reach the standard passing threshold.
-999: The verification process wasn't finished.
     * @param Result The return code of the verification result.
0: Succeeded.
1001: System error.
1004: Selfie verification comparison failed.
2004: The image passed in is too large or too small.
2012: Several faces were detected.
2013: No face was detected, or the face detected was incomplete.
2014: The image resolution is too low or the quality does not meet the requirements.
2015: Face comparison failed.
2016: The similarity did not reach the standard passing threshold.
-999: The verification process wasn't finished.
     */
    public void setResult(String Result) {
        this.Result = Result;
    }

    /**
     * Get The description of the verification result. 
     * @return Description The description of the verification result.
     */
    public String getDescription() {
        return this.Description;
    }

    /**
     * Set The description of the verification result.
     * @param Description The description of the verification result.
     */
    public void setDescription(String Description) {
        this.Description = Description;
    }

    /**
     * Get The best frame screenshot (in Base64) obtained during the verification. 
     * @return BestFrame The best frame screenshot (in Base64) obtained during the verification.
     */
    public String getBestFrame() {
        return this.BestFrame;
    }

    /**
     * Set The best frame screenshot (in Base64) obtained during the verification.
     * @param BestFrame The best frame screenshot (in Base64) obtained during the verification.
     */
    public void setBestFrame(String BestFrame) {
        this.BestFrame = BestFrame;
    }

    /**
     * Get The video file (Base64) for verification.Used for verification, contains specific color reflection effects. 
     * @return Video The video file (Base64) for verification.Used for verification, contains specific color reflection effects.
     */
    public String getVideo() {
        return this.Video;
    }

    /**
     * Set The video file (Base64) for verification.Used for verification, contains specific color reflection effects.
     * @param Video The video file (Base64) for verification.Used for verification, contains specific color reflection effects.
     */
    public void setVideo(String Video) {
        this.Video = Video;
    }

    /**
     * Get Records the specific action performed by the user, used for AI Face Shield analysis. 
     * @return ActionVideo Records the specific action performed by the user, used for AI Face Shield analysis.
     */
    public String getActionVideo() {
        return this.ActionVideo;
    }

    /**
     * Set Records the specific action performed by the user, used for AI Face Shield analysis.
     * @param ActionVideo Records the specific action performed by the user, used for AI Face Shield analysis.
     */
    public void setActionVideo(String ActionVideo) {
        this.ActionVideo = ActionVideo;
    }

    /**
     * Get The similarity, with a value range of 0-100. A greater value indicates higher similarity. This parameter is returned only in the `compare` (selfie verification) mode.
Note: This field may return `null`, indicating that no valid values can be obtained. 
     * @return Similarity The similarity, with a value range of 0-100. A greater value indicates higher similarity. This parameter is returned only in the `compare` (selfie verification) mode.
Note: This field may return `null`, indicating that no valid values can be obtained.
     */
    public Float getSimilarity() {
        return this.Similarity;
    }

    /**
     * Set The similarity, with a value range of 0-100. A greater value indicates higher similarity. This parameter is returned only in the `compare` (selfie verification) mode.
Note: This field may return `null`, indicating that no valid values can be obtained.
     * @param Similarity The similarity, with a value range of 0-100. A greater value indicates higher similarity. This parameter is returned only in the `compare` (selfie verification) mode.
Note: This field may return `null`, indicating that no valid values can be obtained.
     */
    public void setSimilarity(Float Similarity) {
        this.Similarity = Similarity;
    }

    /**
     * Get The pass-through parameter.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Extra The pass-through parameter.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getExtra() {
        return this.Extra;
    }

    /**
     * Set The pass-through parameter.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Extra The pass-through parameter.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setExtra(String Extra) {
        this.Extra = Extra;
    }

    /**
     * Get Describe the risk level of the device where the current request is located, with a total of 4 levels. The details are as follows:
1 - Secure
2 - Low Risk
3 - Medium Risk
4 - High Risk
Empty - Risk level not obtained.
Only returned for the ENHANCED version, with the default value being empty. 
     * @return DeviceInfoLevel Describe the risk level of the device where the current request is located, with a total of 4 levels. The details are as follows:
1 - Secure
2 - Low Risk
3 - Medium Risk
4 - High Risk
Empty - Risk level not obtained.
Only returned for the ENHANCED version, with the default value being empty.
     */
    public String getDeviceInfoLevel() {
        return this.DeviceInfoLevel;
    }

    /**
     * Set Describe the risk level of the device where the current request is located, with a total of 4 levels. The details are as follows:
1 - Secure
2 - Low Risk
3 - Medium Risk
4 - High Risk
Empty - Risk level not obtained.
Only returned for the ENHANCED version, with the default value being empty.
     * @param DeviceInfoLevel Describe the risk level of the device where the current request is located, with a total of 4 levels. The details are as follows:
1 - Secure
2 - Low Risk
3 - Medium Risk
4 - High Risk
Empty - Risk level not obtained.
Only returned for the ENHANCED version, with the default value being empty.
     */
    public void setDeviceInfoLevel(String DeviceInfoLevel) {
        this.DeviceInfoLevel = DeviceInfoLevel;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public GetFaceIdResultIntlResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GetFaceIdResultIntlResponse(GetFaceIdResultIntlResponse source) {
        if (source.Result != null) {
            this.Result = new String(source.Result);
        }
        if (source.Description != null) {
            this.Description = new String(source.Description);
        }
        if (source.BestFrame != null) {
            this.BestFrame = new String(source.BestFrame);
        }
        if (source.Video != null) {
            this.Video = new String(source.Video);
        }
        if (source.ActionVideo != null) {
            this.ActionVideo = new String(source.ActionVideo);
        }
        if (source.Similarity != null) {
            this.Similarity = new Float(source.Similarity);
        }
        if (source.Extra != null) {
            this.Extra = new String(source.Extra);
        }
        if (source.DeviceInfoLevel != null) {
            this.DeviceInfoLevel = new String(source.DeviceInfoLevel);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Result", this.Result);
        this.setParamSimple(map, prefix + "Description", this.Description);
        this.setParamSimple(map, prefix + "BestFrame", this.BestFrame);
        this.setParamSimple(map, prefix + "Video", this.Video);
        this.setParamSimple(map, prefix + "ActionVideo", this.ActionVideo);
        this.setParamSimple(map, prefix + "Similarity", this.Similarity);
        this.setParamSimple(map, prefix + "Extra", this.Extra);
        this.setParamSimple(map, prefix + "DeviceInfoLevel", this.DeviceInfoLevel);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

