/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.gwlb.v20240906.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreateGatewayLoadBalancerResponse extends AbstractModel {

    /**
    * Array of unique GWLB instance IDs.In certain scenarios, for example, when there is a delay in creation, this field may return null; at this time, you can query the created resource ID through the DescribeTaskStatus API using the RequestId or DealName parameter returned by the API.Note: this field may return `null`, indicating that no valid values can be obtained.
    */
    @SerializedName("LoadBalancerIds")
    @Expose
    private String [] LoadBalancerIds;

    /**
    * Order number.

Note: this field may return `null`, indicating that no valid values can be obtained.
    */
    @SerializedName("DealName")
    @Expose
    private String DealName;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Array of unique GWLB instance IDs.In certain scenarios, for example, when there is a delay in creation, this field may return null; at this time, you can query the created resource ID through the DescribeTaskStatus API using the RequestId or DealName parameter returned by the API.Note: this field may return `null`, indicating that no valid values can be obtained. 
     * @return LoadBalancerIds Array of unique GWLB instance IDs.In certain scenarios, for example, when there is a delay in creation, this field may return null; at this time, you can query the created resource ID through the DescribeTaskStatus API using the RequestId or DealName parameter returned by the API.Note: this field may return `null`, indicating that no valid values can be obtained.
     */
    public String [] getLoadBalancerIds() {
        return this.LoadBalancerIds;
    }

    /**
     * Set Array of unique GWLB instance IDs.In certain scenarios, for example, when there is a delay in creation, this field may return null; at this time, you can query the created resource ID through the DescribeTaskStatus API using the RequestId or DealName parameter returned by the API.Note: this field may return `null`, indicating that no valid values can be obtained.
     * @param LoadBalancerIds Array of unique GWLB instance IDs.In certain scenarios, for example, when there is a delay in creation, this field may return null; at this time, you can query the created resource ID through the DescribeTaskStatus API using the RequestId or DealName parameter returned by the API.Note: this field may return `null`, indicating that no valid values can be obtained.
     */
    public void setLoadBalancerIds(String [] LoadBalancerIds) {
        this.LoadBalancerIds = LoadBalancerIds;
    }

    /**
     * Get Order number.

Note: this field may return `null`, indicating that no valid values can be obtained. 
     * @return DealName Order number.

Note: this field may return `null`, indicating that no valid values can be obtained.
     */
    public String getDealName() {
        return this.DealName;
    }

    /**
     * Set Order number.

Note: this field may return `null`, indicating that no valid values can be obtained.
     * @param DealName Order number.

Note: this field may return `null`, indicating that no valid values can be obtained.
     */
    public void setDealName(String DealName) {
        this.DealName = DealName;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public CreateGatewayLoadBalancerResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreateGatewayLoadBalancerResponse(CreateGatewayLoadBalancerResponse source) {
        if (source.LoadBalancerIds != null) {
            this.LoadBalancerIds = new String[source.LoadBalancerIds.length];
            for (int i = 0; i < source.LoadBalancerIds.length; i++) {
                this.LoadBalancerIds[i] = new String(source.LoadBalancerIds[i]);
            }
        }
        if (source.DealName != null) {
            this.DealName = new String(source.DealName);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "LoadBalancerIds.", this.LoadBalancerIds);
        this.setParamSimple(map, prefix + "DealName", this.DealName);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

