/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.kms.v20190118.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GetDataKeyPlaintextResponse extends AbstractModel {

    /**
    * If EncryptionPublicKey is not provided during the call, the field value is the plaintext encoded in Base64, and the Base64 decoding is required to obtain the plaintext. If EncryptionPublicKey is provided during the call, the field value is the ciphertext asymmetrically encrypted with the EncryptionPublicKey and encoded in Base64. After Base64 decoding, the private key corresponding to the user-uploaded public key is used for further decryption to obtain the plaintext.
    */
    @SerializedName("Plaintext")
    @Expose
    private String Plaintext;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get If EncryptionPublicKey is not provided during the call, the field value is the plaintext encoded in Base64, and the Base64 decoding is required to obtain the plaintext. If EncryptionPublicKey is provided during the call, the field value is the ciphertext asymmetrically encrypted with the EncryptionPublicKey and encoded in Base64. After Base64 decoding, the private key corresponding to the user-uploaded public key is used for further decryption to obtain the plaintext. 
     * @return Plaintext If EncryptionPublicKey is not provided during the call, the field value is the plaintext encoded in Base64, and the Base64 decoding is required to obtain the plaintext. If EncryptionPublicKey is provided during the call, the field value is the ciphertext asymmetrically encrypted with the EncryptionPublicKey and encoded in Base64. After Base64 decoding, the private key corresponding to the user-uploaded public key is used for further decryption to obtain the plaintext.
     */
    public String getPlaintext() {
        return this.Plaintext;
    }

    /**
     * Set If EncryptionPublicKey is not provided during the call, the field value is the plaintext encoded in Base64, and the Base64 decoding is required to obtain the plaintext. If EncryptionPublicKey is provided during the call, the field value is the ciphertext asymmetrically encrypted with the EncryptionPublicKey and encoded in Base64. After Base64 decoding, the private key corresponding to the user-uploaded public key is used for further decryption to obtain the plaintext.
     * @param Plaintext If EncryptionPublicKey is not provided during the call, the field value is the plaintext encoded in Base64, and the Base64 decoding is required to obtain the plaintext. If EncryptionPublicKey is provided during the call, the field value is the ciphertext asymmetrically encrypted with the EncryptionPublicKey and encoded in Base64. After Base64 decoding, the private key corresponding to the user-uploaded public key is used for further decryption to obtain the plaintext.
     */
    public void setPlaintext(String Plaintext) {
        this.Plaintext = Plaintext;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public GetDataKeyPlaintextResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GetDataKeyPlaintextResponse(GetDataKeyPlaintextResponse source) {
        if (source.Plaintext != null) {
            this.Plaintext = new String(source.Plaintext);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Plaintext", this.Plaintext);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

