/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.kms.v20190118.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GetServiceStatusResponse extends AbstractModel {

    /**
    * Whether the KMS service has been activated. true: activated
    */
    @SerializedName("ServiceEnabled")
    @Expose
    private Boolean ServiceEnabled;

    /**
    * Service unavailability type: 0-not purchased, 1-normal, 2-service suspended due to overdue payments, 3-resource release.
    */
    @SerializedName("InvalidType")
    @Expose
    private Long InvalidType;

    /**
    * 0: Basic Edition, 1: Ultimate Edition
    */
    @SerializedName("UserLevel")
    @Expose
    private Long UserLevel;

    /**
    * Specifies the expiry time (Epoch Unix Timestamp) of the flagship edition.
    */
    @SerializedName("ProExpireTime")
    @Expose
    private Long ProExpireTime;

    /**
    * Specifies whether the flagship edition is automatically renewed: 0 - no automatic renewal, 1 - automatic renewal.
    */
    @SerializedName("ProRenewFlag")
    @Expose
    private Long ProRenewFlag;

    /**
    * Flagship edition purchase record unique identifier. if not activated, the return value is empty.
    */
    @SerializedName("ProResourceId")
    @Expose
    private String ProResourceId;

    /**
    * Whether to enable the KMS-managed version.
    */
    @SerializedName("ExclusiveVSMEnabled")
    @Expose
    private Boolean ExclusiveVSMEnabled;

    /**
    * Whether to enable the exclusive edition of KMS.
    */
    @SerializedName("ExclusiveHSMEnabled")
    @Expose
    private Boolean ExclusiveHSMEnabled;

    /**
    * Specifies the KMS subscription information.
    */
    @SerializedName("SubscriptionInfo")
    @Expose
    private String SubscriptionInfo;

    /**
    * Returns the amount of KMS user secret keys used.
    */
    @SerializedName("CmkUserCount")
    @Expose
    private Long CmkUserCount;

    /**
    * Returns the specification quantity of KMS user secret keys.
    */
    @SerializedName("CmkLimit")
    @Expose
    private Long CmkLimit;

    /**
    * Return dedicated cluster group.
    */
    @SerializedName("ExclusiveHSMList")
    @Expose
    private ExclusiveHSM [] ExclusiveHSMList;

    /**
    * Whether data key management is supported. valid values: 1 (supported), 0 (unsupported).
    */
    @SerializedName("IsAllowedDataKeyHosted")
    @Expose
    private Boolean IsAllowedDataKeyHosted;

    /**
    * Valid when IsAllowedDataKeyHosted is 1. specifies the purchase quota for data keys.
    */
    @SerializedName("DataKeyLimit")
    @Expose
    private Long DataKeyLimit;

    /**
    * Valid when IsAllowedDataKeyHosted is 1. data key free quota.
    */
    @SerializedName("FreeDataKeyLimit")
    @Expose
    private Long FreeDataKeyLimit;

    /**
    * Valid at that time when IsAllowedDataKeyHosted is 1. specifies the number of keys used.
    */
    @SerializedName("DataKeyUsedCount")
    @Expose
    private Long DataKeyUsedCount;

    /**
    * Specifies the target region of the sync task.
    */
    @SerializedName("SyncTaskList")
    @Expose
    private DestinationSyncConfig [] SyncTaskList;

    /**
    * Whether synchronization task is supported. true: supported; false: unsupported.
    */
    @SerializedName("IsAllowedSync")
    @Expose
    private Boolean IsAllowedSync;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Whether the KMS service has been activated. true: activated 
     * @return ServiceEnabled Whether the KMS service has been activated. true: activated
     */
    public Boolean getServiceEnabled() {
        return this.ServiceEnabled;
    }

    /**
     * Set Whether the KMS service has been activated. true: activated
     * @param ServiceEnabled Whether the KMS service has been activated. true: activated
     */
    public void setServiceEnabled(Boolean ServiceEnabled) {
        this.ServiceEnabled = ServiceEnabled;
    }

    /**
     * Get Service unavailability type: 0-not purchased, 1-normal, 2-service suspended due to overdue payments, 3-resource release. 
     * @return InvalidType Service unavailability type: 0-not purchased, 1-normal, 2-service suspended due to overdue payments, 3-resource release.
     */
    public Long getInvalidType() {
        return this.InvalidType;
    }

    /**
     * Set Service unavailability type: 0-not purchased, 1-normal, 2-service suspended due to overdue payments, 3-resource release.
     * @param InvalidType Service unavailability type: 0-not purchased, 1-normal, 2-service suspended due to overdue payments, 3-resource release.
     */
    public void setInvalidType(Long InvalidType) {
        this.InvalidType = InvalidType;
    }

    /**
     * Get 0: Basic Edition, 1: Ultimate Edition 
     * @return UserLevel 0: Basic Edition, 1: Ultimate Edition
     */
    public Long getUserLevel() {
        return this.UserLevel;
    }

    /**
     * Set 0: Basic Edition, 1: Ultimate Edition
     * @param UserLevel 0: Basic Edition, 1: Ultimate Edition
     */
    public void setUserLevel(Long UserLevel) {
        this.UserLevel = UserLevel;
    }

    /**
     * Get Specifies the expiry time (Epoch Unix Timestamp) of the flagship edition. 
     * @return ProExpireTime Specifies the expiry time (Epoch Unix Timestamp) of the flagship edition.
     */
    public Long getProExpireTime() {
        return this.ProExpireTime;
    }

    /**
     * Set Specifies the expiry time (Epoch Unix Timestamp) of the flagship edition.
     * @param ProExpireTime Specifies the expiry time (Epoch Unix Timestamp) of the flagship edition.
     */
    public void setProExpireTime(Long ProExpireTime) {
        this.ProExpireTime = ProExpireTime;
    }

    /**
     * Get Specifies whether the flagship edition is automatically renewed: 0 - no automatic renewal, 1 - automatic renewal. 
     * @return ProRenewFlag Specifies whether the flagship edition is automatically renewed: 0 - no automatic renewal, 1 - automatic renewal.
     */
    public Long getProRenewFlag() {
        return this.ProRenewFlag;
    }

    /**
     * Set Specifies whether the flagship edition is automatically renewed: 0 - no automatic renewal, 1 - automatic renewal.
     * @param ProRenewFlag Specifies whether the flagship edition is automatically renewed: 0 - no automatic renewal, 1 - automatic renewal.
     */
    public void setProRenewFlag(Long ProRenewFlag) {
        this.ProRenewFlag = ProRenewFlag;
    }

    /**
     * Get Flagship edition purchase record unique identifier. if not activated, the return value is empty. 
     * @return ProResourceId Flagship edition purchase record unique identifier. if not activated, the return value is empty.
     */
    public String getProResourceId() {
        return this.ProResourceId;
    }

    /**
     * Set Flagship edition purchase record unique identifier. if not activated, the return value is empty.
     * @param ProResourceId Flagship edition purchase record unique identifier. if not activated, the return value is empty.
     */
    public void setProResourceId(String ProResourceId) {
        this.ProResourceId = ProResourceId;
    }

    /**
     * Get Whether to enable the KMS-managed version. 
     * @return ExclusiveVSMEnabled Whether to enable the KMS-managed version.
     */
    public Boolean getExclusiveVSMEnabled() {
        return this.ExclusiveVSMEnabled;
    }

    /**
     * Set Whether to enable the KMS-managed version.
     * @param ExclusiveVSMEnabled Whether to enable the KMS-managed version.
     */
    public void setExclusiveVSMEnabled(Boolean ExclusiveVSMEnabled) {
        this.ExclusiveVSMEnabled = ExclusiveVSMEnabled;
    }

    /**
     * Get Whether to enable the exclusive edition of KMS. 
     * @return ExclusiveHSMEnabled Whether to enable the exclusive edition of KMS.
     */
    public Boolean getExclusiveHSMEnabled() {
        return this.ExclusiveHSMEnabled;
    }

    /**
     * Set Whether to enable the exclusive edition of KMS.
     * @param ExclusiveHSMEnabled Whether to enable the exclusive edition of KMS.
     */
    public void setExclusiveHSMEnabled(Boolean ExclusiveHSMEnabled) {
        this.ExclusiveHSMEnabled = ExclusiveHSMEnabled;
    }

    /**
     * Get Specifies the KMS subscription information. 
     * @return SubscriptionInfo Specifies the KMS subscription information.
     */
    public String getSubscriptionInfo() {
        return this.SubscriptionInfo;
    }

    /**
     * Set Specifies the KMS subscription information.
     * @param SubscriptionInfo Specifies the KMS subscription information.
     */
    public void setSubscriptionInfo(String SubscriptionInfo) {
        this.SubscriptionInfo = SubscriptionInfo;
    }

    /**
     * Get Returns the amount of KMS user secret keys used. 
     * @return CmkUserCount Returns the amount of KMS user secret keys used.
     */
    public Long getCmkUserCount() {
        return this.CmkUserCount;
    }

    /**
     * Set Returns the amount of KMS user secret keys used.
     * @param CmkUserCount Returns the amount of KMS user secret keys used.
     */
    public void setCmkUserCount(Long CmkUserCount) {
        this.CmkUserCount = CmkUserCount;
    }

    /**
     * Get Returns the specification quantity of KMS user secret keys. 
     * @return CmkLimit Returns the specification quantity of KMS user secret keys.
     */
    public Long getCmkLimit() {
        return this.CmkLimit;
    }

    /**
     * Set Returns the specification quantity of KMS user secret keys.
     * @param CmkLimit Returns the specification quantity of KMS user secret keys.
     */
    public void setCmkLimit(Long CmkLimit) {
        this.CmkLimit = CmkLimit;
    }

    /**
     * Get Return dedicated cluster group. 
     * @return ExclusiveHSMList Return dedicated cluster group.
     */
    public ExclusiveHSM [] getExclusiveHSMList() {
        return this.ExclusiveHSMList;
    }

    /**
     * Set Return dedicated cluster group.
     * @param ExclusiveHSMList Return dedicated cluster group.
     */
    public void setExclusiveHSMList(ExclusiveHSM [] ExclusiveHSMList) {
        this.ExclusiveHSMList = ExclusiveHSMList;
    }

    /**
     * Get Whether data key management is supported. valid values: 1 (supported), 0 (unsupported). 
     * @return IsAllowedDataKeyHosted Whether data key management is supported. valid values: 1 (supported), 0 (unsupported).
     */
    public Boolean getIsAllowedDataKeyHosted() {
        return this.IsAllowedDataKeyHosted;
    }

    /**
     * Set Whether data key management is supported. valid values: 1 (supported), 0 (unsupported).
     * @param IsAllowedDataKeyHosted Whether data key management is supported. valid values: 1 (supported), 0 (unsupported).
     */
    public void setIsAllowedDataKeyHosted(Boolean IsAllowedDataKeyHosted) {
        this.IsAllowedDataKeyHosted = IsAllowedDataKeyHosted;
    }

    /**
     * Get Valid when IsAllowedDataKeyHosted is 1. specifies the purchase quota for data keys. 
     * @return DataKeyLimit Valid when IsAllowedDataKeyHosted is 1. specifies the purchase quota for data keys.
     */
    public Long getDataKeyLimit() {
        return this.DataKeyLimit;
    }

    /**
     * Set Valid when IsAllowedDataKeyHosted is 1. specifies the purchase quota for data keys.
     * @param DataKeyLimit Valid when IsAllowedDataKeyHosted is 1. specifies the purchase quota for data keys.
     */
    public void setDataKeyLimit(Long DataKeyLimit) {
        this.DataKeyLimit = DataKeyLimit;
    }

    /**
     * Get Valid when IsAllowedDataKeyHosted is 1. data key free quota. 
     * @return FreeDataKeyLimit Valid when IsAllowedDataKeyHosted is 1. data key free quota.
     */
    public Long getFreeDataKeyLimit() {
        return this.FreeDataKeyLimit;
    }

    /**
     * Set Valid when IsAllowedDataKeyHosted is 1. data key free quota.
     * @param FreeDataKeyLimit Valid when IsAllowedDataKeyHosted is 1. data key free quota.
     */
    public void setFreeDataKeyLimit(Long FreeDataKeyLimit) {
        this.FreeDataKeyLimit = FreeDataKeyLimit;
    }

    /**
     * Get Valid at that time when IsAllowedDataKeyHosted is 1. specifies the number of keys used. 
     * @return DataKeyUsedCount Valid at that time when IsAllowedDataKeyHosted is 1. specifies the number of keys used.
     */
    public Long getDataKeyUsedCount() {
        return this.DataKeyUsedCount;
    }

    /**
     * Set Valid at that time when IsAllowedDataKeyHosted is 1. specifies the number of keys used.
     * @param DataKeyUsedCount Valid at that time when IsAllowedDataKeyHosted is 1. specifies the number of keys used.
     */
    public void setDataKeyUsedCount(Long DataKeyUsedCount) {
        this.DataKeyUsedCount = DataKeyUsedCount;
    }

    /**
     * Get Specifies the target region of the sync task. 
     * @return SyncTaskList Specifies the target region of the sync task.
     */
    public DestinationSyncConfig [] getSyncTaskList() {
        return this.SyncTaskList;
    }

    /**
     * Set Specifies the target region of the sync task.
     * @param SyncTaskList Specifies the target region of the sync task.
     */
    public void setSyncTaskList(DestinationSyncConfig [] SyncTaskList) {
        this.SyncTaskList = SyncTaskList;
    }

    /**
     * Get Whether synchronization task is supported. true: supported; false: unsupported. 
     * @return IsAllowedSync Whether synchronization task is supported. true: supported; false: unsupported.
     */
    public Boolean getIsAllowedSync() {
        return this.IsAllowedSync;
    }

    /**
     * Set Whether synchronization task is supported. true: supported; false: unsupported.
     * @param IsAllowedSync Whether synchronization task is supported. true: supported; false: unsupported.
     */
    public void setIsAllowedSync(Boolean IsAllowedSync) {
        this.IsAllowedSync = IsAllowedSync;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public GetServiceStatusResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GetServiceStatusResponse(GetServiceStatusResponse source) {
        if (source.ServiceEnabled != null) {
            this.ServiceEnabled = new Boolean(source.ServiceEnabled);
        }
        if (source.InvalidType != null) {
            this.InvalidType = new Long(source.InvalidType);
        }
        if (source.UserLevel != null) {
            this.UserLevel = new Long(source.UserLevel);
        }
        if (source.ProExpireTime != null) {
            this.ProExpireTime = new Long(source.ProExpireTime);
        }
        if (source.ProRenewFlag != null) {
            this.ProRenewFlag = new Long(source.ProRenewFlag);
        }
        if (source.ProResourceId != null) {
            this.ProResourceId = new String(source.ProResourceId);
        }
        if (source.ExclusiveVSMEnabled != null) {
            this.ExclusiveVSMEnabled = new Boolean(source.ExclusiveVSMEnabled);
        }
        if (source.ExclusiveHSMEnabled != null) {
            this.ExclusiveHSMEnabled = new Boolean(source.ExclusiveHSMEnabled);
        }
        if (source.SubscriptionInfo != null) {
            this.SubscriptionInfo = new String(source.SubscriptionInfo);
        }
        if (source.CmkUserCount != null) {
            this.CmkUserCount = new Long(source.CmkUserCount);
        }
        if (source.CmkLimit != null) {
            this.CmkLimit = new Long(source.CmkLimit);
        }
        if (source.ExclusiveHSMList != null) {
            this.ExclusiveHSMList = new ExclusiveHSM[source.ExclusiveHSMList.length];
            for (int i = 0; i < source.ExclusiveHSMList.length; i++) {
                this.ExclusiveHSMList[i] = new ExclusiveHSM(source.ExclusiveHSMList[i]);
            }
        }
        if (source.IsAllowedDataKeyHosted != null) {
            this.IsAllowedDataKeyHosted = new Boolean(source.IsAllowedDataKeyHosted);
        }
        if (source.DataKeyLimit != null) {
            this.DataKeyLimit = new Long(source.DataKeyLimit);
        }
        if (source.FreeDataKeyLimit != null) {
            this.FreeDataKeyLimit = new Long(source.FreeDataKeyLimit);
        }
        if (source.DataKeyUsedCount != null) {
            this.DataKeyUsedCount = new Long(source.DataKeyUsedCount);
        }
        if (source.SyncTaskList != null) {
            this.SyncTaskList = new DestinationSyncConfig[source.SyncTaskList.length];
            for (int i = 0; i < source.SyncTaskList.length; i++) {
                this.SyncTaskList[i] = new DestinationSyncConfig(source.SyncTaskList[i]);
            }
        }
        if (source.IsAllowedSync != null) {
            this.IsAllowedSync = new Boolean(source.IsAllowedSync);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ServiceEnabled", this.ServiceEnabled);
        this.setParamSimple(map, prefix + "InvalidType", this.InvalidType);
        this.setParamSimple(map, prefix + "UserLevel", this.UserLevel);
        this.setParamSimple(map, prefix + "ProExpireTime", this.ProExpireTime);
        this.setParamSimple(map, prefix + "ProRenewFlag", this.ProRenewFlag);
        this.setParamSimple(map, prefix + "ProResourceId", this.ProResourceId);
        this.setParamSimple(map, prefix + "ExclusiveVSMEnabled", this.ExclusiveVSMEnabled);
        this.setParamSimple(map, prefix + "ExclusiveHSMEnabled", this.ExclusiveHSMEnabled);
        this.setParamSimple(map, prefix + "SubscriptionInfo", this.SubscriptionInfo);
        this.setParamSimple(map, prefix + "CmkUserCount", this.CmkUserCount);
        this.setParamSimple(map, prefix + "CmkLimit", this.CmkLimit);
        this.setParamArrayObj(map, prefix + "ExclusiveHSMList.", this.ExclusiveHSMList);
        this.setParamSimple(map, prefix + "IsAllowedDataKeyHosted", this.IsAllowedDataKeyHosted);
        this.setParamSimple(map, prefix + "DataKeyLimit", this.DataKeyLimit);
        this.setParamSimple(map, prefix + "FreeDataKeyLimit", this.FreeDataKeyLimit);
        this.setParamSimple(map, prefix + "DataKeyUsedCount", this.DataKeyUsedCount);
        this.setParamArrayObj(map, prefix + "SyncTaskList.", this.SyncTaskList);
        this.setParamSimple(map, prefix + "IsAllowedSync", this.IsAllowedSync);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

