/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.kms.v20190118.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ImportDataKeyRequest extends AbstractModel {

    /**
    * Name of the data key.
    */
    @SerializedName("DataKeyName")
    @Expose
    private String DataKeyName;

    /**
    * If the imported key is plaintext data key, it is the base64 plaintext data key after conversion. if the imported key is ciphertext data key, it is the ciphertext data key generated by the KMS GenerateDataKey interface.
    */
    @SerializedName("ImportKeyMaterial")
    @Expose
    private String ImportKeyMaterial;

    /**
    * 1: ciphertext import (data key generated by KMS api) 2: plaintext import.
    */
    @SerializedName("ImportType")
    @Expose
    private Long ImportType;

    /**
    * Describes the data key. maximum 100 bytes.
    */
    @SerializedName("Description")
    @Expose
    private String Description;

    /**
    * When importing an encrypted data key, no need to input the root key. if the input is provided, validate whether the KeyId matches the one in the ciphertext.
When importing plaintext data key, KeyId cannot be empty. the data key is encrypted with the specified root key.
    */
    @SerializedName("KeyId")
    @Expose
    private String KeyId;

    /**
    * HSM cluster ID corresponding to the KMS exclusive edition. if HsmClusterId is specified, it indicates the root key is in this cluster and verifies whether KeyId corresponds to HsmClusterId.
    */
    @SerializedName("HsmClusterId")
    @Expose
    private String HsmClusterId;

    /**
     * Get Name of the data key. 
     * @return DataKeyName Name of the data key.
     */
    public String getDataKeyName() {
        return this.DataKeyName;
    }

    /**
     * Set Name of the data key.
     * @param DataKeyName Name of the data key.
     */
    public void setDataKeyName(String DataKeyName) {
        this.DataKeyName = DataKeyName;
    }

    /**
     * Get If the imported key is plaintext data key, it is the base64 plaintext data key after conversion. if the imported key is ciphertext data key, it is the ciphertext data key generated by the KMS GenerateDataKey interface. 
     * @return ImportKeyMaterial If the imported key is plaintext data key, it is the base64 plaintext data key after conversion. if the imported key is ciphertext data key, it is the ciphertext data key generated by the KMS GenerateDataKey interface.
     */
    public String getImportKeyMaterial() {
        return this.ImportKeyMaterial;
    }

    /**
     * Set If the imported key is plaintext data key, it is the base64 plaintext data key after conversion. if the imported key is ciphertext data key, it is the ciphertext data key generated by the KMS GenerateDataKey interface.
     * @param ImportKeyMaterial If the imported key is plaintext data key, it is the base64 plaintext data key after conversion. if the imported key is ciphertext data key, it is the ciphertext data key generated by the KMS GenerateDataKey interface.
     */
    public void setImportKeyMaterial(String ImportKeyMaterial) {
        this.ImportKeyMaterial = ImportKeyMaterial;
    }

    /**
     * Get 1: ciphertext import (data key generated by KMS api) 2: plaintext import. 
     * @return ImportType 1: ciphertext import (data key generated by KMS api) 2: plaintext import.
     */
    public Long getImportType() {
        return this.ImportType;
    }

    /**
     * Set 1: ciphertext import (data key generated by KMS api) 2: plaintext import.
     * @param ImportType 1: ciphertext import (data key generated by KMS api) 2: plaintext import.
     */
    public void setImportType(Long ImportType) {
        this.ImportType = ImportType;
    }

    /**
     * Get Describes the data key. maximum 100 bytes. 
     * @return Description Describes the data key. maximum 100 bytes.
     */
    public String getDescription() {
        return this.Description;
    }

    /**
     * Set Describes the data key. maximum 100 bytes.
     * @param Description Describes the data key. maximum 100 bytes.
     */
    public void setDescription(String Description) {
        this.Description = Description;
    }

    /**
     * Get When importing an encrypted data key, no need to input the root key. if the input is provided, validate whether the KeyId matches the one in the ciphertext.
When importing plaintext data key, KeyId cannot be empty. the data key is encrypted with the specified root key. 
     * @return KeyId When importing an encrypted data key, no need to input the root key. if the input is provided, validate whether the KeyId matches the one in the ciphertext.
When importing plaintext data key, KeyId cannot be empty. the data key is encrypted with the specified root key.
     */
    public String getKeyId() {
        return this.KeyId;
    }

    /**
     * Set When importing an encrypted data key, no need to input the root key. if the input is provided, validate whether the KeyId matches the one in the ciphertext.
When importing plaintext data key, KeyId cannot be empty. the data key is encrypted with the specified root key.
     * @param KeyId When importing an encrypted data key, no need to input the root key. if the input is provided, validate whether the KeyId matches the one in the ciphertext.
When importing plaintext data key, KeyId cannot be empty. the data key is encrypted with the specified root key.
     */
    public void setKeyId(String KeyId) {
        this.KeyId = KeyId;
    }

    /**
     * Get HSM cluster ID corresponding to the KMS exclusive edition. if HsmClusterId is specified, it indicates the root key is in this cluster and verifies whether KeyId corresponds to HsmClusterId. 
     * @return HsmClusterId HSM cluster ID corresponding to the KMS exclusive edition. if HsmClusterId is specified, it indicates the root key is in this cluster and verifies whether KeyId corresponds to HsmClusterId.
     */
    public String getHsmClusterId() {
        return this.HsmClusterId;
    }

    /**
     * Set HSM cluster ID corresponding to the KMS exclusive edition. if HsmClusterId is specified, it indicates the root key is in this cluster and verifies whether KeyId corresponds to HsmClusterId.
     * @param HsmClusterId HSM cluster ID corresponding to the KMS exclusive edition. if HsmClusterId is specified, it indicates the root key is in this cluster and verifies whether KeyId corresponds to HsmClusterId.
     */
    public void setHsmClusterId(String HsmClusterId) {
        this.HsmClusterId = HsmClusterId;
    }

    public ImportDataKeyRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ImportDataKeyRequest(ImportDataKeyRequest source) {
        if (source.DataKeyName != null) {
            this.DataKeyName = new String(source.DataKeyName);
        }
        if (source.ImportKeyMaterial != null) {
            this.ImportKeyMaterial = new String(source.ImportKeyMaterial);
        }
        if (source.ImportType != null) {
            this.ImportType = new Long(source.ImportType);
        }
        if (source.Description != null) {
            this.Description = new String(source.Description);
        }
        if (source.KeyId != null) {
            this.KeyId = new String(source.KeyId);
        }
        if (source.HsmClusterId != null) {
            this.HsmClusterId = new String(source.HsmClusterId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "DataKeyName", this.DataKeyName);
        this.setParamSimple(map, prefix + "ImportKeyMaterial", this.ImportKeyMaterial);
        this.setParamSimple(map, prefix + "ImportType", this.ImportType);
        this.setParamSimple(map, prefix + "Description", this.Description);
        this.setParamSimple(map, prefix + "KeyId", this.KeyId);
        this.setParamSimple(map, prefix + "HsmClusterId", this.HsmClusterId);

    }
}

