/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.kms.v20190118.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class PostQuantumCryptoEncryptRequest extends AbstractModel {

    /**
    * Globally unique ID of the CMK generated by calling the `CreateKey` API
    */
    @SerializedName("KeyId")
    @Expose
    private String KeyId;

    /**
    * Encrypted plaintext data. This field must be Base64-encoded. The maximum size of the original data is 4 KB.
    */
    @SerializedName("PlainText")
    @Expose
    private String PlainText;

    /**
     * Get Globally unique ID of the CMK generated by calling the `CreateKey` API 
     * @return KeyId Globally unique ID of the CMK generated by calling the `CreateKey` API
     */
    public String getKeyId() {
        return this.KeyId;
    }

    /**
     * Set Globally unique ID of the CMK generated by calling the `CreateKey` API
     * @param KeyId Globally unique ID of the CMK generated by calling the `CreateKey` API
     */
    public void setKeyId(String KeyId) {
        this.KeyId = KeyId;
    }

    /**
     * Get Encrypted plaintext data. This field must be Base64-encoded. The maximum size of the original data is 4 KB. 
     * @return PlainText Encrypted plaintext data. This field must be Base64-encoded. The maximum size of the original data is 4 KB.
     */
    public String getPlainText() {
        return this.PlainText;
    }

    /**
     * Set Encrypted plaintext data. This field must be Base64-encoded. The maximum size of the original data is 4 KB.
     * @param PlainText Encrypted plaintext data. This field must be Base64-encoded. The maximum size of the original data is 4 KB.
     */
    public void setPlainText(String PlainText) {
        this.PlainText = PlainText;
    }

    public PostQuantumCryptoEncryptRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public PostQuantumCryptoEncryptRequest(PostQuantumCryptoEncryptRequest source) {
        if (source.KeyId != null) {
            this.KeyId = new String(source.KeyId);
        }
        if (source.PlainText != null) {
            this.PlainText = new String(source.PlainText);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "KeyId", this.KeyId);
        this.setParamSimple(map, prefix + "PlainText", this.PlainText);

    }
}

