/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lighthouse.v20200324.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeDisksReturnableResponse extends AbstractModel {

    /**
    * List of returnable cloud disks.
    */
    @SerializedName("DiskReturnableSet")
    @Expose
    private DiskReturnable [] DiskReturnableSet;

    /**
    * Number of eligible cloud disks.
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * The unique request ID, which is returned for each request. RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get List of returnable cloud disks. 
     * @return DiskReturnableSet List of returnable cloud disks.
     */
    public DiskReturnable [] getDiskReturnableSet() {
        return this.DiskReturnableSet;
    }

    /**
     * Set List of returnable cloud disks.
     * @param DiskReturnableSet List of returnable cloud disks.
     */
    public void setDiskReturnableSet(DiskReturnable [] DiskReturnableSet) {
        this.DiskReturnableSet = DiskReturnableSet;
    }

    /**
     * Get Number of eligible cloud disks. 
     * @return TotalCount Number of eligible cloud disks.
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Number of eligible cloud disks.
     * @param TotalCount Number of eligible cloud disks.
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get The unique request ID, which is returned for each request. RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     * @param RequestId The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeDisksReturnableResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeDisksReturnableResponse(DescribeDisksReturnableResponse source) {
        if (source.DiskReturnableSet != null) {
            this.DiskReturnableSet = new DiskReturnable[source.DiskReturnableSet.length];
            for (int i = 0; i < source.DiskReturnableSet.length; i++) {
                this.DiskReturnableSet[i] = new DiskReturnable(source.DiskReturnableSet[i]);
            }
        }
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "DiskReturnableSet.", this.DiskReturnableSet);
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

