/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lighthouse.v20200324.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ModifyBundle extends AbstractModel {

    /**
    * Price difference that you need to pay for the new instance package after change.
    */
    @SerializedName("ModifyPrice")
    @Expose
    private Price ModifyPrice;

    /**
    * Package change status. Valid values:
<li>SOLD_OUT: packages are sold out</li>
<li>AVAILABLE: packages can be changed</li>
<li>UNAVAILABLE: packages cannot be changed currently</li>
    */
    @SerializedName("ModifyBundleState")
    @Expose
    private String ModifyBundleState;

    /**
    * Package information.
    */
    @SerializedName("Bundle")
    @Expose
    private Bundle Bundle;

    /**
    * The reason of package changing failure. It’s empty if the package change status is `AVAILABLE`.
Note: This field may return `null`, indicating that no valid values can be obtained.
    */
    @SerializedName("NotSupportModifyMessage")
    @Expose
    private String NotSupportModifyMessage;

    /**
     * Get Price difference that you need to pay for the new instance package after change. 
     * @return ModifyPrice Price difference that you need to pay for the new instance package after change.
     */
    public Price getModifyPrice() {
        return this.ModifyPrice;
    }

    /**
     * Set Price difference that you need to pay for the new instance package after change.
     * @param ModifyPrice Price difference that you need to pay for the new instance package after change.
     */
    public void setModifyPrice(Price ModifyPrice) {
        this.ModifyPrice = ModifyPrice;
    }

    /**
     * Get Package change status. Valid values:
<li>SOLD_OUT: packages are sold out</li>
<li>AVAILABLE: packages can be changed</li>
<li>UNAVAILABLE: packages cannot be changed currently</li> 
     * @return ModifyBundleState Package change status. Valid values:
<li>SOLD_OUT: packages are sold out</li>
<li>AVAILABLE: packages can be changed</li>
<li>UNAVAILABLE: packages cannot be changed currently</li>
     */
    public String getModifyBundleState() {
        return this.ModifyBundleState;
    }

    /**
     * Set Package change status. Valid values:
<li>SOLD_OUT: packages are sold out</li>
<li>AVAILABLE: packages can be changed</li>
<li>UNAVAILABLE: packages cannot be changed currently</li>
     * @param ModifyBundleState Package change status. Valid values:
<li>SOLD_OUT: packages are sold out</li>
<li>AVAILABLE: packages can be changed</li>
<li>UNAVAILABLE: packages cannot be changed currently</li>
     */
    public void setModifyBundleState(String ModifyBundleState) {
        this.ModifyBundleState = ModifyBundleState;
    }

    /**
     * Get Package information. 
     * @return Bundle Package information.
     */
    public Bundle getBundle() {
        return this.Bundle;
    }

    /**
     * Set Package information.
     * @param Bundle Package information.
     */
    public void setBundle(Bundle Bundle) {
        this.Bundle = Bundle;
    }

    /**
     * Get The reason of package changing failure. It’s empty if the package change status is `AVAILABLE`.
Note: This field may return `null`, indicating that no valid values can be obtained. 
     * @return NotSupportModifyMessage The reason of package changing failure. It’s empty if the package change status is `AVAILABLE`.
Note: This field may return `null`, indicating that no valid values can be obtained.
     */
    public String getNotSupportModifyMessage() {
        return this.NotSupportModifyMessage;
    }

    /**
     * Set The reason of package changing failure. It’s empty if the package change status is `AVAILABLE`.
Note: This field may return `null`, indicating that no valid values can be obtained.
     * @param NotSupportModifyMessage The reason of package changing failure. It’s empty if the package change status is `AVAILABLE`.
Note: This field may return `null`, indicating that no valid values can be obtained.
     */
    public void setNotSupportModifyMessage(String NotSupportModifyMessage) {
        this.NotSupportModifyMessage = NotSupportModifyMessage;
    }

    public ModifyBundle() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ModifyBundle(ModifyBundle source) {
        if (source.ModifyPrice != null) {
            this.ModifyPrice = new Price(source.ModifyPrice);
        }
        if (source.ModifyBundleState != null) {
            this.ModifyBundleState = new String(source.ModifyBundleState);
        }
        if (source.Bundle != null) {
            this.Bundle = new Bundle(source.Bundle);
        }
        if (source.NotSupportModifyMessage != null) {
            this.NotSupportModifyMessage = new String(source.NotSupportModifyMessage);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "ModifyPrice.", this.ModifyPrice);
        this.setParamSimple(map, prefix + "ModifyBundleState", this.ModifyBundleState);
        this.setParamObj(map, prefix + "Bundle.", this.Bundle);
        this.setParamSimple(map, prefix + "NotSupportModifyMessage", this.NotSupportModifyMessage);

    }
}

